/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.client;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.Tracer;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceManager {
    private static final String ELIPSIS = "...";
    private static ResourceManager manager = null;
    private Map resources = new HashMap();
    private String encoding = null;

    private static ResourceManager getInstance() {
        if (manager == null) {
            manager = new ResourceManager();
        }
        return manager;
    }

    public static String getResource(Class owner, String propertyName, ClassLoader loader) {
        return ResourceManager.getInstance().getResource(owner, Locale.getDefault(), propertyName, loader);
    }

    public static String getResource(Class owner, String propertyName) {
        return ResourceManager.getResource(owner, propertyName, Locale.getDefault());
    }

    public static String getResource(Class owner, String propertyName, Locale locale) {
        return ResourceManager.getInstance().getResource(owner, locale, propertyName, null);
    }

    private String getResource(Class holder, Locale locale, String propertyName, ClassLoader loader) throws MissingResourceException {
        java.util.ResourceBundle bundle = this.getBundle(holder, locale, loader);
        if (bundle == null) {
            throw new DeveloperException("no bundle for holder=" + holder.getName());
        }
        String valueRaw = bundle.getString(propertyName);
        if (this.encoding != null) {
            try {
                return new String(valueRaw.getBytes("ISO-8859-1"), this.encoding);
            }
            catch (UnsupportedEncodingException ex) {
                Tracer.getInstance().runtimeWarning("encoding failed: " + ex.getLocalizedMessage());
            }
        }
        return valueRaw;
    }

    public static void setCharacterSet(String encoding) {
        ResourceManager.getInstance().encoding = encoding;
    }

    private java.util.ResourceBundle getBundle(Class holder, Locale locale, ClassLoader loader) {
        Map<Class, java.util.ResourceBundle> languages = null;
        if (this.resources.containsKey(locale.getLanguage())) {
            languages = (Map)this.resources.get(locale.getLanguage());
        } else {
            languages = new HashMap();
            this.resources.put(locale.getLanguage(), languages);
        }
        if (languages.containsKey(holder)) {
            return (java.util.ResourceBundle)languages.get(holder);
        }
        java.util.ResourceBundle bundle = null;
        bundle = loader == null ? ResourceBundle.getBundle(holder, locale) : ResourceBundle.getBundle(holder, locale, loader);
        languages.put(holder, bundle);
        return bundle;
    }

    private static String getResource(Class owner, String propertyName, boolean asLabel) {
        try {
            String resource = ResourceManager.getInstance().getResource(owner, Locale.getDefault(), propertyName, null).trim();
            return ResourceManager.convertLabel(resource, asLabel);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static String getResourceAsLabel(Class owner, String propertyName) {
        return ResourceManager.getResource(owner, propertyName, true);
    }

    public static String getResourceAsContinued(Class owner, String propertyName) {
        String resource = ResourceManager.getResourceAsNonLabeled(owner, propertyName);
        if (resource != null && !resource.endsWith(ELIPSIS)) {
            return resource + ELIPSIS;
        }
        return resource;
    }

    public static String getResourceAsNonLabeled(Class owner, String propertyName) {
        return ResourceManager.getResource(owner, propertyName, false);
    }

    public static String getResourceMatch(Class owner, String pattern, boolean asLabel) throws MissingResourceException {
        java.util.ResourceBundle bundle = ResourceManager.getInstance().getBundle(owner, Locale.getDefault(), null);
        Enumeration<String> keys = bundle.getKeys();
        Pattern p = Pattern.compile(pattern);
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Matcher m = p.matcher(key);
            if (!m.matches()) continue;
            return ResourceManager.convertLabel(bundle.getString(key), asLabel);
        }
        throw new MissingResourceException("No key matching pattern: " + pattern, owner.getName(), pattern);
    }

    private static String convertLabel(String resource, boolean asLabel) {
        if (resource == null) {
            return resource;
        }
        if (asLabel) {
            if (resource.charAt(resource.length() - 1) != ':') {
                return resource + ":";
            }
        } else if (resource.charAt(resource.length() - 1) == ':') {
            return resource.substring(0, resource.length() - 1);
        }
        return resource;
    }
}

