/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.transport.TransportResponse;

public class ScrollQueryFetchSearchResult
extends TransportResponse {
    private QueryFetchSearchResult result;
    private SearchShardTarget shardTarget;

    public ScrollQueryFetchSearchResult() {
    }

    public ScrollQueryFetchSearchResult(QueryFetchSearchResult result, SearchShardTarget shardTarget) {
        this.result = result;
        this.shardTarget = shardTarget;
    }

    public QueryFetchSearchResult result() {
        return this.result;
    }

    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardTarget = new SearchShardTarget(in);
        this.result = QueryFetchSearchResult.readQueryFetchSearchResult(in);
        this.result.shardTarget(this.shardTarget);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardTarget.writeTo(out);
        this.result.writeTo(out);
    }
}

