/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Config;
import esmska.data.GatewayConfig;
import esmska.data.GatewayInfo;
import esmska.data.Gateways;
import esmska.data.Icons;
import esmska.data.Signature;
import esmska.data.Signatures;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.text.Collator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;

public class Gateway
implements GatewayInfo,
Comparable<Gateway> {
    public static final String UNKNOWN = L10N.l10nBundle.getString("Gateway.unknown");
    private static final Logger logger = Logger.getLogger(Gateway.class.getName());
    public static final int maxMessageLength = 1000;
    private static final int maxMaxParts = 5;
    private URL script;
    private String name;
    private String version;
    private String maintainer;
    private String website;
    private String description;
    private String minProgramVersion;
    private String[] supportedPrefixes;
    private String[] preferredPrefixes;
    private String[] supportedLanguages;
    private String[] features;
    private int smsLength;
    private int maxParts;
    private int maxChars;
    private int delayBetweenMessages;
    private Icon icon;
    private boolean favorite;
    private boolean hidden;
    private GatewayConfig config = new GatewayConfig();
    private static final Pattern namePattern = Pattern.compile("^\\[(\\w\\w|INT)\\].+");
    private static final Collator collator = Collator.getInstance();

    public Gateway(URL script) throws IOException, ScriptException, PrivilegedActionException, IntrospectionException {
        this.script = script;
        GatewayInfo info = Gateways.parseInfo(script);
        String string = this.name = info != null ? info.getName() : null;
        if (StringUtils.isEmpty(this.name)) {
            throw new ScriptException("Not a valid gateway script", script.toExternalForm(), 0);
        }
        if (!namePattern.matcher(this.name).matches()) {
            throw new IllegalArgumentException("Gateway name not valid: " + this.name);
        }
        this.version = info.getVersion();
        this.maintainer = info.getMaintainer();
        this.minProgramVersion = info.getMinProgramVersion();
        this.website = info.getWebsite();
        this.description = info.getDescription();
        this.supportedPrefixes = info.getSupportedPrefixes();
        this.preferredPrefixes = info.getPreferredPrefixes();
        this.smsLength = info.getSMSLength();
        this.maxChars = info.getMaxChars();
        this.delayBetweenMessages = info.getDelayBetweenMessages();
        this.supportedLanguages = info.getSupportedLanguages();
        this.features = info.getFeatures();
        String iconName = script.toExternalForm().replaceFirst("\\.gateway$", ".png");
        URL iconURL = new URL(iconName);
        this.icon = new ImageIcon(iconURL);
        if (this.icon.getIconWidth() <= 0) {
            this.icon = Icons.GATEWAY_DEFAULT;
        }
        this.maxParts = 1000 / this.maxChars;
        this.maxParts = Math.min(this.maxParts, 5);
        logger.log(Level.FINER, "Created new gateway: {0}", this.toString());
    }

    public URL getScript() {
        return this.script;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean hasFeature(Feature feature) {
        for (String featName : this.features) {
            if (!feature.name().equalsIgnoreCase(featName)) continue;
            return true;
        }
        return false;
    }

    public int getMaxParts() {
        return this.maxParts;
    }

    public GatewayConfig getConfig() {
        return this.config;
    }

    public void setConfig(GatewayConfig config) {
        this.config = config;
    }

    public String getSenderName() {
        Signature signature = Signatures.getInstance().get(this.getConfig().getSignature());
        if (signature == null || StringUtils.isEmpty(signature.getUserName())) {
            return "";
        }
        String result = signature.getUserName();
        if (Config.getInstance().isRemoveAccents()) {
            result = MiscUtils.removeAccents(result);
        }
        return result;
    }

    @Override
    public int compareTo(Gateway o) {
        return collator.compare(this.getName(), o.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Gateway)) {
            return false;
        }
        Gateway o = (Gateway)obj;
        return this.compareTo(o) == 0;
    }

    public String toString() {
        return this.name + " [version=" + this.version + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getMaintainer() {
        return this.maintainer;
    }

    @Override
    public String getMinProgramVersion() {
        return this.minProgramVersion;
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getSupportedPrefixes() {
        return this.supportedPrefixes;
    }

    @Override
    public String[] getPreferredPrefixes() {
        return this.preferredPrefixes;
    }

    @Override
    public int getSMSLength() {
        return this.smsLength;
    }

    @Override
    public int getMaxChars() {
        return this.maxChars;
    }

    @Override
    public int getDelayBetweenMessages() {
        return this.delayBetweenMessages;
    }

    @Override
    public String[] getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @Override
    public String[] getFeatures() {
        return this.features;
    }

    public static enum Feature {
        LOGIN,
        LOGIN_ONLY,
        SENDER_NUMBER,
        RECEIPT,
        CAPTCHA;

    }
}

