/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean isInheritorOrSelf(@Nullable PsiClass aClass2, @Nullable PsiClass baseClass, boolean checkDeep) {
        if (aClass2 == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass2.getManager();
        return manager.areElementsEquivalent(baseClass, aClass2) || aClass2.isInheritor(baseClass, checkDeep);
    }

    public static boolean processSupers(@Nullable PsiClass aClass2, boolean includeSelf, @NotNull Processor<PsiClass> superProcessor) {
        if (superProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superProcessor", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "processSupers"));
        }
        if (aClass2 == null) {
            return true;
        }
        if (includeSelf && !superProcessor.process(aClass2)) {
            return false;
        }
        return InheritanceUtil.processSupers(aClass2, superProcessor, new THashSet<PsiClass>());
    }

    private static boolean processSupers(@NotNull PsiClass aClass2, @NotNull Processor<PsiClass> superProcessor, @NotNull Set<PsiClass> visited2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "processSupers"));
        }
        if (superProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superProcessor", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "processSupers"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "processSupers"));
        }
        if (!visited2.add(aClass2)) {
            return true;
        }
        for (PsiClass intf : aClass2.getInterfaces()) {
            if (superProcessor.process(intf) && InheritanceUtil.processSupers(intf, superProcessor, visited2)) continue;
            return false;
        }
        PsiClass superClass = aClass2.getSuperClass();
        return superClass == null || superProcessor.process(superClass) && InheritanceUtil.processSupers(superClass, superProcessor, visited2);
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiType type2, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "isInheritor"));
        }
        if (type2 instanceof PsiClassType) {
            return InheritanceUtil.isInheritor(((PsiClassType)type2).resolve(), baseClassName);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, @NotNull String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "isInheritor"));
        }
        return InheritanceUtil.isInheritor(psiClass, false, baseClassName);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, boolean strict, @NotNull String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "isInheritor"));
        }
        if (psiClass == null) {
            return false;
        }
        PsiClass base = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(baseClassName, psiClass.getResolveScope());
        if (base == null) {
            return false;
        }
        return strict ? psiClass.isInheritor(base, true) : InheritanceUtil.isInheritorOrSelf(psiClass, base, true);
    }

    public static void getSuperClasses(@NotNull PsiClass aClass2, @NotNull Set<PsiClass> results, boolean includeNonProject) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "getSuperClasses"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "getSuperClasses"));
        }
        InheritanceUtil.getSuperClassesOfList(aClass2.getSuperTypes(), results, includeNonProject, new THashSet<PsiClass>(), aClass2.getManager());
    }

    public static LinkedHashSet<PsiClass> getSuperClasses(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "getSuperClasses"));
        }
        LinkedHashSet<PsiClass> result2 = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses(aClass2, result2, true);
        return result2;
    }

    private static void getSuperClassesOfList(@NotNull PsiClassType[] types, @NotNull Set<PsiClass> results, boolean includeNonProject, @NotNull Set<PsiClass> visited2, @NotNull PsiManager manager) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "getSuperClassesOfList"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "getSuperClassesOfList"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "getSuperClassesOfList"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil", "getSuperClassesOfList"));
        }
        for (PsiClassType type2 : types) {
            PsiClass resolved = type2.resolve();
            if (resolved == null || !visited2.add(resolved)) continue;
            if (includeNonProject || manager.isInProject(resolved)) {
                results.add(resolved);
            }
            InheritanceUtil.getSuperClassesOfList(resolved.getSuperTypes(), results, includeNonProject, visited2, manager);
        }
    }

    public static boolean hasEnclosingInstanceInScope(PsiClass aClass2, PsiElement scope, boolean isSuperClassAccepted, boolean isTypeParamsAccepted) {
        PsiElement place;
        PsiManager manager = aClass2.getManager();
        for (place = scope; place != null && place != aClass2 && !(place instanceof PsiFile); place = place.getParent()) {
            PsiModifierList modifierList;
            if (place instanceof PsiClass) {
                if (isSuperClassAccepted ? InheritanceUtil.isInheritorOrSelf((PsiClass)place, aClass2, true) : manager.areElementsEquivalent(place, aClass2)) {
                    return true;
                }
                if (isTypeParamsAccepted && place instanceof PsiTypeParameter) {
                    return true;
                }
            }
            if (!(place instanceof PsiModifierListOwner) || (modifierList = ((PsiModifierListOwner)place).getModifierList()) == null || !modifierList.hasModifierProperty("static")) continue;
            return false;
        }
        return place == aClass2;
    }
}

