/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileCollectionSnapshotter snapshotter;

    public OutputFilesCollectionSnapshotter(FileCollectionSnapshotter snapshotter) {
        this.snapshotter = snapshotter;
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
        this.snapshotter.registerSerializers(registry);
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return this.snapshotter.emptySnapshot();
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection files, TaskFilePropertyCompareStrategy compareStrategy, SnapshotNormalizationStrategy snapshotNormalizationStrategy) {
        return this.snapshotter.snapshot(files, compareStrategy, snapshotNormalizationStrategy);
    }

    @Override
    public FileCollectionSnapshot snapshot(TaskFilePropertySpec propertySpec) {
        return this.snapshotter.snapshot(propertySpec);
    }

    public FileCollectionSnapshot createOutputSnapshot(FileCollectionSnapshot afterPreviousExecution, FileCollectionSnapshot beforeExecution, FileCollectionSnapshot afterExecution, FileCollection roots) {
        FileCollectionSnapshot filesSnapshot;
        Map<String, NormalizedFileSnapshot> afterSnapshots = afterExecution.getSnapshots();
        if (!beforeExecution.getSnapshots().isEmpty() && !afterSnapshots.isEmpty()) {
            Map<String, NormalizedFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
            HashMap<String, NormalizedFileSnapshot> afterPreviousSnapshots = afterPreviousExecution != null ? afterPreviousExecution.getSnapshots() : new HashMap<String, NormalizedFileSnapshot>();
            int newEntryCount = 0;
            ImmutableMap.Builder outputEntries = ImmutableMap.builder();
            for (Map.Entry<String, NormalizedFileSnapshot> entry : afterSnapshots.entrySet()) {
                NormalizedFileSnapshot fileSnapshot;
                String path = entry.getKey();
                if (!OutputFilesCollectionSnapshotter.isOutputEntry(path, fileSnapshot = entry.getValue(), beforeSnapshots, afterPreviousSnapshots)) continue;
                outputEntries.put((Object)entry.getKey(), (Object)fileSnapshot);
                ++newEntryCount;
            }
            filesSnapshot = newEntryCount == afterSnapshots.size() ? afterExecution : new DefaultFileCollectionSnapshot((Map<String, NormalizedFileSnapshot>)outputEntries.build(), TaskFilePropertyCompareStrategy.OUTPUT, true);
        } else {
            filesSnapshot = afterExecution;
        }
        return filesSnapshot;
    }

    private static boolean isOutputEntry(String path, NormalizedFileSnapshot fileSnapshot, Map<String, NormalizedFileSnapshot> beforeSnapshots, Map<String, NormalizedFileSnapshot> afterPreviousSnapshots) {
        NormalizedFileSnapshot beforeSnapshot = beforeSnapshots.get(path);
        if (beforeSnapshot == null) {
            return true;
        }
        if (!fileSnapshot.getSnapshot().isContentAndMetadataUpToDate(beforeSnapshot.getSnapshot())) {
            return true;
        }
        return afterPreviousSnapshots.containsKey(path);
    }
}

