/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class SingletonFileTree
implements MinimalFileTree {
    private final File file;
    private final FileSystem fileSystem = FileSystems.getDefault();

    public SingletonFileTree(File file) {
        this.file = file;
    }

    public String getDisplayName() {
        return String.format("file '%s'", this.file);
    }

    public void visit(FileVisitor visitor) {
        visitor.visitFile(new SingletonFileVisitDetails(this.file, this.fileSystem, false));
    }

    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        builder.add(this.file);
    }

    public void visitTreeOrBackingFile(FileVisitor visitor) {
        this.visit(visitor);
    }

    public static class SingletonFileVisitDetails
    extends DefaultFileVisitDetails {
        public SingletonFileVisitDetails(File file, FileSystem fileSystem, boolean isDirectory) {
            super(file, new RelativePath(true, file.getName()), new AtomicBoolean(), (Chmod)fileSystem, (Stat)fileSystem, isDirectory);
        }
    }
}

