import { Observable } from '../Observable';
/**
 * Similar to the well-known `Array.prototype.filter` method, this operator filters values down to a set
 * allowed by a `select` function
 *
 * @param {Function} select a function that is used to select the resulting values
 *  if it returns `true`, the value is emitted, if `false` the value is not passed to the resulting observable
 * @param {any} [thisArg] an optional argument to determine the value of `this` in the `select` function
 * @return {Observable} an observable of values allowed by the select function
 * @method filter
 * @owner Observable
 */
export declare function filter<T>(select: (value: T, index: number) => boolean, thisArg?: any): Observable<T>;
export interface FilterSignature<T> {
    (select: (value: T, index: number) => boolean, thisArg?: any): Observable<T>;
}
