/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.jmol.util.Logger;
import org.openscience.jmol.app.nbo.ArchiveViewer;
import org.openscience.jmol.app.nbo.ChooseList;
import org.openscience.jmol.app.nbo.FileHndlr;
import org.openscience.jmol.app.nbo.HelpBtn;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBODialogModel;

abstract class NBODialogRun
extends NBODialogModel {
    protected static final String RUN_EXTENSIONS = "47;gau;gms";
    protected static final String[] keywordList = new String[]{"CMO: Bonding character of canonical MO's", "DIPOLE: Dipole moment analysis", "NBBP: Natural bond-bond polarizability indeces", "NBCP: Natural bond critical point analysis", "NCE: Natural coulomb electrostatics analysis", "NCU: Natural cluster unit analysis", "NRT: Natural resonance theory analysis", "PLOT: Write files for orbital plotting", "STERIC: Natural steric analysis"};
    protected Box editBox;
    protected JRadioButton rbLocal;
    protected JRadioButton[] keywordButtons;
    protected JButton run;
    String[] fileData;
    String nboKeywords;
    protected JTextField plotFileName;
    protected boolean isOpenShell;
    ChooseList chooseList;

    protected NBODialogRun(JFrame f) {
        super(f);
    }

    protected JPanel buildRunPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(NBODialogRun.titleBox(" Select Job ", new HelpBtn("run_job_help.htm")));
        Box inputBox = this.borderBox(true);
        this.panel.add(inputBox);
        if (this.fileHndlr == null) {
            this.fileHndlr = new FileHndlr("", "47", 2, "47", (NBODialog)this);
            this.fileHndlr.browse.setEnabled(false);
        } else {
            this.fileHndlr = new FileHndlr(this.fileHndlr.jobStem, this.fileHndlr.tfExt.getText(), 2, "47", (NBODialog)this);
        }
        this.fileHndlr.browse.setEnabled(false);
        Box box = Box.createHorizontalBox();
        ButtonGroup bg = new ButtonGroup();
        this.rbLocal = new JRadioButton("Local");
        this.rbLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.fileHndlr.browse.setEnabled(true);
            }
        });
        box.add(this.rbLocal);
        bg.add(this.rbLocal);
        JRadioButton btn = new JRadioButton("NBOrXiv");
        final NBODialogRun d = this;
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL rxiv = null;
                try {
                    rxiv = new URL("http://nbo6.chem.wisc.edu/jmol_nborxiv/");
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ArchiveViewer aView = new ArchiveViewer((NBODialog)d, rxiv);
                aView.setVisible(true);
            }
        });
        box.add(btn);
        bg.add(btn);
        btn = new JRadioButton("WebMO");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = "http://www.webmo.net/demoserver/cgi-bin/webmo/jobmgr.cgi";
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception e1) {
                    NBODialogRun.this.vwr.alert("Could not open WebMO");
                }
            }
        });
        box.add(btn);
        bg.add(btn);
        inputBox.add(box);
        inputBox.add(this.fileHndlr);
        inputBox.setMaximumSize(new Dimension(355, 80));
        this.panel.add(NBODialogRun.titleBox(" Choose $NBO Keywords ", new HelpBtn("run_keywords_help.htm"))).setVisible(false);
        this.editBox = this.borderBox(true);
        this.editBox.setMinimumSize(new Dimension(350, 400));
        this.plotFileName = new JTextField();
        this.editBox.setVisible(false);
        this.panel.add(this.editBox);
        this.run = new JButton("Run");
        this.run.setVisible(false);
        this.panel.add(this.run).setFont(new Font("Arial", 0, 20));
        this.run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.runJob("", NBODialogRun.this.fileHndlr.inputFile, "gennbo");
            }
        });
        String ext = this.fileHndlr.tfExt.getText();
        if (ext.equals("47")) {
            this.notifyLoad_r();
        }
        return this.panel;
    }

    @Override
    protected void showAtomNums(boolean alpha) {
        if (!this.showAtNum) {
            this.runScriptQueued("select {*};label off; select remove {*}");
            return;
        }
        SB sb = new SB();
        sb.append("select {*};label %a;");
        if (this.chooseList != null) {
            Hashtable<String, String> lonePairs = alpha ? this.chooseList.lonePairs : this.chooseList.lonePairs_b;
            Hashtable<String, String> loneV = this.chooseList.lv;
            for (int i = 1; i <= this.vwr.ms.ac; ++i) {
                String lv;
                sb.append("select (atomno=" + i + ");label ");
                String atNum = new Integer(i).toString();
                String lp = lonePairs.get(atNum);
                if (lp != null && !lp.equals("0")) {
                    sb.append("<sup>(" + lp + ")</sup>");
                }
                if ((lv = loneV.get(atNum)) != null && !lv.equals("0")) {
                    sb.append("<sub>[" + lv + "]</sub>");
                }
                sb.append("%a;");
            }
        }
        this.runScriptQueued(sb.toString());
        sb = new SB();
        String color = this.nboView ? "black" : "gray";
        sb.append("select {*};color labels white;");
        sb.append("select {H*};color labels " + color + ";" + "set labeloffset 0 0 {*}; select remove {*};");
        this.runScriptQueued(sb.toString());
    }

    protected String cleanNBOKeylist(String params) {
        String[] tokens = PT.getTokens(PT.rep(PT.clean(params), "file=", "FILE="));
        String tmp = "";
        for (String s : tokens) {
            if (s.length() <= 0) continue;
            if (s.toLowerCase().contains("file=") && this.plotFileName != null) {
                this.plotFileName.setText(s.substring(s.indexOf("=") + 1));
                continue;
            }
            if (tmp.length() + s.length() - tmp.lastIndexOf(sep) >= 80) {
                tmp = tmp + sep + " ";
            }
            tmp = tmp + s.toUpperCase() + " ";
        }
        if (this.plotFileName != null && this.plotFileName.getText().equals("")) {
            this.plotFileName.setText(this.fileHndlr.jobStem);
        }
        return tmp;
    }

    protected void setBonds(boolean alpha) {
        SB tmp = alpha ? this.chooseList.bonds : this.chooseList.bonds_b;
        String bonds = tmp.toString();
        if (!bonds.trim().equals("")) {
            this.vwr.ms.deleteAllBonds();
            for (String s : bonds.split("\n")) {
                String[] tokens = s.split(":");
                String key = tokens[0];
                String[] atoms = tokens[1].split(" ");
                int at1 = Integer.parseInt(atoms[0]);
                int at2 = Integer.parseInt(atoms[1]);
                int order = 0;
                short mag = 250;
                switch (key.charAt(0)) {
                    case 'S': {
                        order = 1;
                        break;
                    }
                    case 'D': {
                        order = 2;
                        break;
                    }
                    case 'T': {
                        order = 3;
                        mag = 150;
                        break;
                    }
                    case 'Q': {
                        order = 4;
                        mag = 100;
                        break;
                    }
                    default: {
                        order = Integer.parseInt(key);
                        mag = 100;
                    }
                }
                this.vwr.ms.bondAtoms(this.vwr.ms.at[at1 - 1], this.vwr.ms.at[at2 - 1], order, mag, this.vwr.ms.bsVisible, 0.0f, true, true);
            }
        }
        if (this.nboView) {
            String s2 = this.runScriptNow("print {*}.bonds");
            this.runScriptQueued("select " + s2 + ";color bonds lightgrey");
        }
    }

    protected void setChooseList(String data) {
        this.chooseList = new ChooseList();
        String[] tokens = PT.split(data, "END");
        int ind = 0;
        SB bonds = this.chooseList.bonds;
        SB bonds3c = this.chooseList.bonds3c;
        Hashtable<String, String> lonePairs = this.chooseList.lonePairs;
        if (data.trim().contains("ALPHA")) {
            this.isOpenShell = true;
            ind = 1;
        }
        for (String x : tokens) {
            int j;
            String[] list = x.trim().split("\\s+");
            if (list[0].trim().equals("BETA")) {
                bonds = this.chooseList.bonds_b;
                bonds3c = this.chooseList.bonds3c_b;
                lonePairs = this.chooseList.lonePairs_b;
                ind = 1;
            }
            if (list[ind].trim().equals("LONE")) {
                for (j = 1 + ind; j < list.length; j += 2) {
                    lonePairs.put(list[j], list[j + 1]);
                }
            } else if (list[ind].trim().equals("BOND")) {
                for (j = 1 + ind; j < list.length; j += 3) {
                    bonds.append(list[j] + ":" + list[j + 1] + " " + list[j + 2] + "\n");
                }
            } else if (list[ind].equals("3C")) {
                for (j = 1 + ind; j < list.length; j += 4) {
                    bonds3c.append(list[j] + ":" + list[j + 1] + " " + list[j + 2] + " " + list[j + 3] + "\n");
                }
            }
            ind = 0;
        }
    }

    protected void showNboOutput(String f) {
        String data = this.fileHndlr.getFileData(f);
        JDialog d = new JDialog();
        d.setLayout(new BorderLayout());
        JTextPane p = new JTextPane();
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(p);
        p.setEditable(false);
        p.setText(data);
        d.add((Component)sp, "Center");
        this.centerDialog(d);
        d.setSize(new Dimension(500, 500));
        d.setVisible(true);
    }

    protected String getFileContents(String jobName) {
        String fileContents = this.fileData[0] + "$NBO\n " + "FILE=" + jobName + " " + this.nboKeywords + "  $END" + sep;
        return fileContents + this.fileData[2];
    }

    protected void essChanged(String item, DefaultComboBoxModel<String> editModel) {
        this.fileHndlr.clearInputFile();
        this.editBox.removeAll();
        this.editBox.add(Box.createRigidArea(new Dimension(430, 230)));
        if (item.equals("GenNBO")) {
            this.fileHndlr.tfExt.setText("47");
            this.fileHndlr.useExt = "47";
            editModel.removeElement("Gaussian Input File");
            return;
        }
        if (item.equals("GO9")) {
            this.fileHndlr.tfExt.setText("gau");
            this.fileHndlr.useExt = "gau";
            return;
        }
    }

    protected void editOpChanged(String item) {
        this.editBox.removeAll();
        if (item.equals("-type-")) {
            this.editBox.add(Box.createRigidArea(new Dimension(320, 295)));
        } else if (item.startsWith("$NBO")) {
            this.addNBOKeylist();
        } else if (item.startsWith("Gaussian")) {
            JScrollPane p = new JScrollPane();
            this.editBox.add(p);
        }
        this.repaint();
        this.revalidate();
    }

    protected void addNBOKeylist() {
        if (this.fileHndlr.inputFile != null) {
            this.editBox.removeAll();
            this.editBox.add(Box.createRigidArea(new Dimension(350, 0)));
            final DefaultListModel<String> sList = new DefaultListModel<String>();
            String tmp = "";
            for (String s : this.nboKeywords.split("\\s+")) {
                if (s.length() <= 0 || s.toUpperCase().contains("FILE=")) continue;
                sList.addElement(s);
                tmp = tmp + s + " ";
            }
            this.nboKeywords = tmp;
            final JList keywords = new JList(sList);
            keywords.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        NBODialogRun.this.removeListParams(keywords.getSelectedValuesList(), sList);
                    }
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Jobname ")).setFont(new Font("Arial", 1, 16));
            box.add(this.plotFileName).setMaximumSize(new Dimension(100, 30));
            box.setAlignmentX(0.5f);
            Box box2 = Box.createVerticalBox();
            box2.add(box);
            JLabel lab = new JLabel("(Plot files will be created with this name)");
            lab.setAlignmentX(0.5f);
            box2.add(lab);
            this.editBox.add(box2);
            box2 = Box.createHorizontalBox();
            box2.add(new JLabel("Keywords:  ")).setFont(new Font("Arial", 1, 16));
            final JPanel menu = this.menuNboKeywords();
            ButtonGroup bg = new ButtonGroup();
            JRadioButton btn = new JRadioButton("Menu Select");
            bg.add(btn);
            box2.add(btn);
            final JPanel manEdit = this.addManualEditor();
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    manEdit.setVisible(false);
                    menu.setVisible(true);
                }
            });
            btn.doClick();
            btn = new JRadioButton("Text Editor");
            bg.add(btn);
            box2.add(btn);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    menu.setVisible(false);
                    manEdit.setVisible(true);
                }
            });
            this.editBox.add(box2);
            manEdit.setAlignmentX(0.5f);
            this.editBox.add(manEdit);
            this.editBox.add(menu);
        }
    }

    private JPanel menuNboKeywords() {
        JPanel menu = new JPanel();
        menu.setLayout(new BoxLayout(menu, 1));
        menu.setBorder(BorderFactory.createLoweredBevelBorder());
        this.keywordButtons = new JRadioButton[keywordList.length];
        for (int i = 0; i < this.keywordButtons.length; ++i) {
            this.keywordButtons[i] = new JRadioButton(keywordList[i]);
            if (this.nboKeywords.contains(keywordList[i].split(":")[0])) {
                this.keywordButtons[i].setSelected(true);
            }
            final int op = i;
            this.keywordButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key = keywordList[op].split(":")[0];
                    if (NBODialogRun.this.keywordButtons[op].isSelected()) {
                        NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords + key + " ";
                        NBODialogRun.this.appendOutputWithCaret("Keyword added: " + key, 'i');
                    } else {
                        NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords.replaceAll(key + " ", "");
                        NBODialogRun.this.appendOutputWithCaret("Keyword removed: " + key, 'i');
                    }
                }
            });
            this.keywordButtons[i].setAlignmentX(0.0f);
            menu.add(this.keywordButtons[i]);
        }
        JLabel lab2 = new JLabel("(Select one or more)");
        menu.add(lab2);
        menu.setAlignmentX(0.5f);
        menu.setMinimumSize(new Dimension(300, 250));
        menu.setVisible(false);
        return menu;
    }

    protected JPanel addManualEditor() {
        JScrollPane sp = new JScrollPane();
        JPanel d = new JPanel(new BorderLayout());
        final JTextPane p = new JTextPane();
        sp.setPreferredSize(new Dimension(200, 200));
        sp.getViewport().add(p);
        d.add((Component)sp, "Center");
        p.setText("$NBO\nFile=" + this.plotFileName.getText() + " " + this.nboKeywords + "\n$END");
        p.setCaretPosition(7);
        JButton btn = new JButton("Save Changes");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = p.getText();
                String tmp = s.replace("$NBO", "").replace("$END", "");
                NBODialogRun.this.nboKeywords = "";
                for (String x : tmp.split("\\s+")) {
                    x = x.trim();
                    System.out.println(x);
                    if (x.length() == 0) continue;
                    if (x.indexOf("=") < 0) {
                        NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords + x + " ";
                        continue;
                    }
                    NBODialogRun.this.plotFileName.setText(x.substring(x.indexOf("=") + 1));
                }
                NBODialogRun.this.addNBOKeylist();
                NBODialogRun.this.editBox.repaint();
                NBODialogRun.this.editBox.revalidate();
            }
        });
        d.add((Component)btn, "South");
        d.setVisible(false);
        d.setMaximumSize(new Dimension(300, 200));
        return d;
    }

    protected void removeListParams(List<String> list, DefaultListModel<String> listModel) {
        this.appendOutputWithCaret("Keyword(s) removed:", 'p');
        for (String x : list) {
            listModel.removeElement(x);
            if (!this.nboKeywords.toUpperCase().contains(x.toUpperCase())) continue;
            this.nboKeywords = this.nboKeywords.substring(0, this.nboKeywords.indexOf(x.toUpperCase())) + this.nboKeywords.substring(this.nboKeywords.indexOf(x.toUpperCase()) + x.length());
            this.appendOutputWithCaret("  " + x, 'i');
        }
    }

    protected void runJob(String keywords, File inputFile, String ess) {
        int i;
        String jobName;
        String label = "";
        if (this.fileData == null) {
            this.fileData = this.fileHndlr.read47File();
            this.nboKeywords = this.fileData[1];
        }
        if (!(jobName = this.plotFileName == null ? this.fileHndlr.jobStem : this.plotFileName.getText().trim()).equals(this.fileHndlr.jobStem) && (i = JOptionPane.showConfirmDialog(null, "Warning, plot files are being created with name " + jobName + ".\nChange to match job name?\n(view will not work correctly if not)", "Warning", 0)) == 0) {
            jobName = this.fileHndlr.jobStem;
        }
        for (String x : keywords.split(" ")) {
            if (this.nboKeywords.contains(x + " ")) continue;
            this.nboKeywords = this.nboKeywords + x + " ";
        }
        if (!this.nboKeywords.contains("PLOT")) {
            this.nboKeywords = this.nboKeywords + "PLOT";
        }
        if (this.fileHndlr.useExt.equals("47")) {
            try {
                FileHndlr.writeToFile(this.getFileContents(jobName), inputFile);
            }
            catch (IOException e) {
                Logger.info("Could not create " + inputFile);
                return;
            }
        }
        SB sb = new SB();
        sb.append("GLOBAL C_PATH " + inputFile.getParent() + sep);
        sb.append("GLOBAL C_JOBSTEM " + this.fileHndlr.jobStem + sep);
        sb.append("GLOBAL C_ESS " + ess.toLowerCase() + sep);
        sb.append("GLOBAL C_LABEL_1 FILE=" + (jobName.equals("") ? this.fileHndlr.jobStem : jobName));
        this.nboService.rawCmdNew("r", sb, 20, null, "Running GenNBO...");
    }

    protected void notifyLoad_r() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        this.fileData = this.fileHndlr.read47File();
        this.nboKeywords = this.cleanNBOKeylist(this.fileData[1]);
        if (this.fileHndlr.useExt.equals("47")) {
            if (!this.fileHndlr.getChooseList()) {
                File f = FileHndlr.newNBOFile(this.fileHndlr.inputFile, "nbo");
                if (f.exists()) {
                    this.vwr.alert("Error reading $CHOOSE list");
                }
            } else {
                this.setBonds(true);
            }
        }
        this.showAtomNums(true);
        this.addNBOKeylist();
        for (Component c : this.panel.getComponents()) {
            c.setVisible(true);
        }
        this.editBox.getParent().setVisible(true);
        this.editBox.setVisible(true);
        this.repaint();
        this.revalidate();
    }

    @Override
    protected void showConfirmationDialog(String st, File newFile, String ext) {
        int i = JOptionPane.showConfirmDialog(this, st, "Message", 0);
        if (i == 0) {
            JDialog d = new JDialog(this);
            d.setLayout(new BorderLayout());
            JTextPane tp = new JTextPane();
            d.add((Component)tp, "Center");
            d.setSize(new Dimension(500, 600));
            tp.setText(this.fileHndlr.getFileData(FileHndlr.newNBOFile(newFile, "nbo").toString()));
            d.setVisible(true);
        }
    }
}

