/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import javajs.J2SRequireImport;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.Quat;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Model;
import org.jmol.modelset.Structure;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;

@J2SRequireImport(value={Short.class, JC.class})
public class Group
implements Structure {
    public static String standardGroupList;
    public static String[] group3Names;
    public static String[] specialAtomNames;
    public Chain chain;
    public int groupIndex;
    public char group1;
    public int firstAtomIndex = -1;
    public int leadAtomIndex = -1;
    public int lastAtomIndex;
    private BS bsAdded;
    public int seqcode;
    public short groupID;
    public int selectedIndex;
    private static final int SEQUENCE_NUMBER_FLAG = 128;
    private static final int INSERTION_CODE_MASK = 127;
    private static final int SEQUENCE_NUMBER_SHIFT = 8;
    public int shapeVisibilityFlags;

    public Group setGroup(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex) {
        this.chain = chain;
        this.seqcode = seqcode;
        this.firstAtomIndex = firstAtomIndex;
        this.lastAtomIndex = lastAtomIndex;
        if (group3 != null && group3.length() > 0) {
            this.setGroupID(group3);
        }
        return this;
    }

    protected void setGroupID(String group3) {
    }

    public boolean isAdded(int atomIndex) {
        return this.bsAdded != null && this.bsAdded.get(atomIndex);
    }

    public void addAtoms(int atomIndex) {
        if (this.bsAdded == null) {
            this.bsAdded = new BS();
        }
        this.bsAdded.set(atomIndex);
    }

    @Override
    public void setAtomBits(BS bs) {
        bs.setBits(this.firstAtomIndex, this.lastAtomIndex + 1);
        if (this.bsAdded != null) {
            bs.or(this.bsAdded);
        }
    }

    @Override
    public void setAtomBitsAndClear(BS bs, BS bsOut) {
        bs.setBits(this.firstAtomIndex, this.lastAtomIndex + 1);
        bsOut.clearBits(this.firstAtomIndex, this.lastAtomIndex + 1);
        if (this.bsAdded != null) {
            bs.or(this.bsAdded);
            bsOut.andNot(this.bsAdded);
        }
    }

    public boolean isSelected(BS bs) {
        int pt = bs.nextSetBit(this.firstAtomIndex);
        return pt >= 0 && pt <= this.lastAtomIndex || this.bsAdded != null && this.bsAdded.intersects(bs);
    }

    public final void setShapeVisibility(int visFlag, boolean isVisible) {
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= visFlag) : (this.shapeVisibilityFlags &= ~visFlag);
    }

    public String getGroup3() {
        return this.groupID < 1 ? "" : group3Names[this.groupID];
    }

    public char getGroup1() {
        return '?';
    }

    public int getBioPolymerLength() {
        return 0;
    }

    public int getMonomerIndex() {
        return -1;
    }

    public Structure getStructure() {
        return null;
    }

    public int getStrucNo() {
        return 0;
    }

    public STR getProteinStructureType() {
        return STR.NOT;
    }

    public STR getProteinStructureSubType() {
        return this.getProteinStructureType();
    }

    public int setProteinStructureType(STR type, int monomerIndexCurrent) {
        return -1;
    }

    public boolean isProtein() {
        return this.groupID >= 1 && this.groupID < 24;
    }

    public boolean isNucleic() {
        return this.groupID >= 24 && this.groupID < 42;
    }

    public boolean isDna() {
        return this.isDnaByID();
    }

    public boolean isRna() {
        return this.isRnaByID();
    }

    public boolean isPurine() {
        return this.isPurineByID();
    }

    protected boolean isPurineByID() {
        return this.isNucleic() && (0x25965 & 1 << this.groupID - 24) != 0;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidineByID();
    }

    protected boolean isPyrimidineByID() {
        return this.isNucleic() && (0x1A69A & 1 << this.groupID - 24) != 0;
    }

    protected boolean isRnaByID() {
        return this.isNucleic() && (0x30037 & 1 << this.groupID - 24) != 0;
    }

    protected boolean isDnaByID() {
        return this.isNucleic() && (0xFFC8 & 1 << this.groupID - 24) != 0;
    }

    public boolean isCarbohydrate() {
        return false;
    }

    public final int getResno() {
        return this.seqcode == Integer.MIN_VALUE ? 0 : this.seqcode >> 8;
    }

    public void setResno(int i) {
        this.seqcode = Group.getSeqcodeFor(i, this.getInsertionCode());
    }

    public static final int getSeqNumberFor(int seqcode) {
        return Group.haveSequenceNumber(seqcode) ? seqcode >> 8 : Integer.MAX_VALUE;
    }

    public static final boolean haveSequenceNumber(int seqcode) {
        return (seqcode & 0x80) != 0;
    }

    public final String getSeqcodeString() {
        return Group.getSeqcodeStringFor(this.seqcode);
    }

    public static int getSeqcodeFor(int seqNo, char insCode) {
        if (seqNo == Integer.MIN_VALUE) {
            return seqNo;
        }
        if (!(insCode >= 'A' && insCode <= 'Z' || insCode >= 'a' && insCode <= 'z' || insCode >= '0' && insCode <= '9' || insCode == '?' || insCode == '*')) {
            if (insCode != ' ' && insCode != '\u0000') {
                Logger.warn("unrecognized insertionCode:" + insCode);
            }
            insCode = '\u0000';
        }
        return (seqNo == Integer.MAX_VALUE ? 0 : seqNo << 8 | 0x80) + insCode;
    }

    public static String getSeqcodeStringFor(int seqcode) {
        if (seqcode == Integer.MIN_VALUE) {
            return null;
        }
        String s = "" + (seqcode >> 8);
        if ((seqcode & 0x7F) != 0) {
            s = s + "^" + (char)(seqcode & 0x7F);
        }
        return s;
    }

    public char getInsertionCode() {
        return this.seqcode == Integer.MIN_VALUE ? (char)'\u0000' : (char)(this.seqcode & 0x7F);
    }

    public final int getInsCode() {
        return this.seqcode & 0x7F;
    }

    public static int getInsertionCodeFor(int seqcode) {
        return seqcode & 0x7F;
    }

    public static char getInsertionCodeChar(int seqcode) {
        return seqcode == Integer.MIN_VALUE ? (char)'\u0000' : (char)(seqcode & 0x7F);
    }

    protected float scaleToScreen(int Z, int mar) {
        return this.chain.model.ms.vwr.tm.scaleToScreen(Z, mar);
    }

    protected boolean isCursorOnTopOf(Atom atom, int x, int y, int radius, Atom champ) {
        return this.chain.model.ms.isCursorOnTopOf(atom, x, y, radius, champ);
    }

    public Model getModel() {
        return this.chain.model;
    }

    public int getSelectedMonomerCount() {
        return 0;
    }

    public int getSelectedMonomerIndex() {
        return -1;
    }

    public boolean isLeadAtom(int atomIndex) {
        return false;
    }

    public Atom getLeadAtomOr(Atom atom) {
        Atom a = this.getLeadAtom();
        return a == null ? atom : a;
    }

    public Atom getLeadAtom() {
        return null;
    }

    public Quat getQuaternion(char qType) {
        return null;
    }

    public Quat getQuaternionFrame(Atom[] atoms) {
        if (this.lastAtomIndex - this.firstAtomIndex < 3) {
            return null;
        }
        int pt = this.firstAtomIndex;
        return Quat.getQuaternionFrame(atoms[pt], atoms[++pt], atoms[++pt]);
    }

    public void setStrucNo(int i) {
    }

    public Object getHelixData(int tokType, char qType, int mStep) {
        return Escape.escapeHelical(null, tokType, null, null, null);
    }

    public boolean isWithinStructure(STR type) {
        return false;
    }

    public String getProteinStructureTag() {
        return null;
    }

    public String getStructureId() {
        return "";
    }

    public int getBioPolymerIndexInModel() {
        return -1;
    }

    public boolean isCrossLinked(Group g) {
        return false;
    }

    public boolean getCrossLinkVector(Lst<Integer> vReturn, boolean crosslinkCovalent, boolean crosslinkHBond) {
        return false;
    }

    public boolean isConnectedPrevious() {
        return false;
    }

    public Atom getNitrogenAtom() {
        return null;
    }

    public Atom getCarbonylOxygenAtom() {
        return null;
    }

    public void fixIndices(int atomsDeleted, BS bsDeleted) {
        this.firstAtomIndex -= atomsDeleted;
        this.leadAtomIndex -= atomsDeleted;
        this.lastAtomIndex -= atomsDeleted;
        if (this.bsAdded != null) {
            BSUtil.deleteBits(this.bsAdded, bsDeleted);
        }
    }

    public Map<String, Object> getGroupInfo(int igroup, P3 ptTemp) {
        Hashtable<String, Object> infoGroup = new Hashtable<String, Object>();
        infoGroup.put("groupIndex", igroup);
        infoGroup.put("groupID", this.groupID);
        String s = this.getSeqcodeString();
        if (s != null) {
            infoGroup.put("seqCode", s);
        }
        infoGroup.put("_apt1", this.firstAtomIndex);
        infoGroup.put("_apt2", this.lastAtomIndex);
        if (this.bsAdded != null) {
            infoGroup.put("addedAtoms", this.bsAdded);
        }
        infoGroup.put("atomInfo1", this.chain.model.ms.getAtomInfo(this.firstAtomIndex, null, ptTemp));
        infoGroup.put("atomInfo2", this.chain.model.ms.getAtomInfo(this.lastAtomIndex, null, ptTemp));
        infoGroup.put("visibilityFlags", this.shapeVisibilityFlags);
        return infoGroup;
    }

    public void getMinZ(Atom[] atoms, int[] minZ) {
        int i;
        minZ[0] = Integer.MAX_VALUE;
        for (i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            this.checkMinZ(atoms[i], minZ);
        }
        if (this.bsAdded != null) {
            i = this.bsAdded.nextSetBit(0);
            while (i >= 0) {
                this.checkMinZ(atoms[i], minZ);
                i = this.bsAdded.nextSetBit(i + 1);
            }
        }
    }

    private void checkMinZ(Atom atom, int[] minZ) {
        int z = atom.sZ - atom.sD / 2 - 2;
        if (z < minZ[0]) {
            minZ[0] = Math.max(1, z);
        }
    }

    public float getGroupParameter(int tok) {
        return Float.NaN;
    }

    public int getAtomIndex(String name, int offset) {
        return -1;
    }

    public BS getBSSideChain() {
        return new BS();
    }

    public String toString() {
        return "[" + this.getGroup3() + "-" + this.getSeqcodeString() + "]";
    }

    static {
        group3Names = new String[128];
    }
}

