/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.CallType;

public class MatchInstr
extends CallInstr
implements FixedArityInstr {
    public MatchInstr(Variable result2, Operand receiver2, Operand arg2) {
        super(Operation.MATCH, CallType.NORMAL, result2, "=~", receiver2, new Operand[]{arg2}, null, false);
        assert (result2 != null) : "Match2Instr result is null";
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        super.computeScopeFlags(scope);
        scope.getFlags().add(IRFlags.USES_BACKREF_OR_LASTLINE);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new MatchInstr((Variable)this.result.cloneForInlining(ii), this.getReceiver().cloneForInlining(ii), this.getArg1().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        e.encode(this.getOperation());
        e.encode(this.getResult());
        e.encode(this.getReceiver());
        e.encode(this.getArg1());
    }

    public static MatchInstr decode(IRReaderDecoder d) {
        return new MatchInstr(d.decodeVariable(), d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.MatchInstr(this);
    }
}

