/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GraphPrintVisitor
implements Closeable {
    public static final String GraphVisualizerAddress = "127.0.0.1";
    public static final int GraphVisualizerPort = 4444;
    private static final String DEFAULT_GRAPH_NAME = "truffle tree";
    private Map<Object, NodeElement> nodeMap;
    private List<EdgeElement> edgeList;
    private Map<Object, NodeElement> prevNodeMap;
    private int id;
    private Impl xmlstream;
    private OutputStream outputStream;
    private int openGroupCount;
    private int openGraphCount;
    private String currentGraphName;

    public GraphPrintVisitor() {
        this(new ByteArrayOutputStream());
    }

    public GraphPrintVisitor(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.xmlstream = GraphPrintVisitor.createImpl(outputStream);
        this.xmlstream.writeStartDocument();
        this.xmlstream.writeStartElement("graphDocument");
    }

    private static Impl createImpl(OutputStream outputStream) {
        return new XMLImpl(outputStream);
    }

    private void ensureOpen() {
        if (this.xmlstream == null) {
            throw new IllegalStateException("printer is closed");
        }
    }

    public GraphPrintVisitor beginGroup(String groupName) {
        this.ensureOpen();
        this.maybeEndGraph();
        ++this.openGroupCount;
        this.xmlstream.writeStartElement("group");
        this.xmlstream.writeStartElement("properties");
        if (!groupName.isEmpty()) {
            this.xmlstream.writeStartElement("p");
            this.xmlstream.writeAttribute("name", "name");
            this.xmlstream.writeCharacters(groupName);
            this.xmlstream.writeEndElement();
        }
        this.xmlstream.writeEndElement();
        this.prevNodeMap = null;
        this.nodeMap = new IdentityHashMap<Object, NodeElement>();
        this.edgeList = new ArrayList<EdgeElement>();
        return this;
    }

    public GraphPrintVisitor endGroup() {
        this.ensureOpen();
        if (this.openGroupCount <= 0) {
            throw new IllegalArgumentException("no open group");
        }
        this.maybeEndGraph();
        --this.openGroupCount;
        this.xmlstream.writeEndElement();
        return this;
    }

    public GraphPrintVisitor beginGraph(String graphName) {
        this.ensureOpen();
        if (this.openGroupCount == 0) {
            this.beginGroup(graphName);
        }
        this.maybeEndGraph();
        ++this.openGraphCount;
        this.currentGraphName = graphName;
        this.prevNodeMap = this.nodeMap;
        this.nodeMap = new IdentityHashMap<Object, NodeElement>();
        this.edgeList = new ArrayList<EdgeElement>();
        return this;
    }

    private void maybeEndGraph() {
        if (this.openGraphCount > 0) {
            this.endGraph();
            assert (this.openGraphCount == 0);
        }
    }

    public GraphPrintVisitor endGraph() {
        this.ensureOpen();
        if (this.openGraphCount <= 0) {
            throw new IllegalArgumentException("no open graph");
        }
        --this.openGraphCount;
        this.xmlstream.writeStartElement("graph");
        this.xmlstream.writeStartElement("properties");
        this.xmlstream.writeStartElement("p");
        this.xmlstream.writeAttribute("name", "name");
        this.xmlstream.writeCharacters(this.currentGraphName);
        this.xmlstream.writeEndElement();
        this.xmlstream.writeEndElement();
        this.xmlstream.writeStartElement("nodes");
        this.writeNodes();
        this.xmlstream.writeEndElement();
        this.xmlstream.writeStartElement("edges");
        this.writeEdges();
        this.xmlstream.writeEndElement();
        this.xmlstream.writeEndElement();
        this.xmlstream.flush();
        return this;
    }

    private void writeNodes() {
        for (NodeElement node : this.nodeMap.values()) {
            this.xmlstream.writeStartElement("node");
            this.xmlstream.writeAttribute("id", String.valueOf(node.getId()));
            this.xmlstream.writeStartElement("properties");
            for (Map.Entry<String, Object> property : node.getProperties().entrySet()) {
                this.xmlstream.writeStartElement("p");
                this.xmlstream.writeAttribute("name", property.getKey());
                this.xmlstream.writeCharacters(GraphPrintVisitor.safeToString(property.getValue()));
                this.xmlstream.writeEndElement();
            }
            this.xmlstream.writeEndElement();
            this.xmlstream.writeEndElement();
        }
    }

    private void writeEdges() {
        for (EdgeElement edge : this.edgeList) {
            this.xmlstream.writeStartElement("edge");
            this.xmlstream.writeAttribute("from", String.valueOf(edge.getFrom().getId()));
            this.xmlstream.writeAttribute("to", String.valueOf(edge.getTo().getId()));
            this.xmlstream.writeAttribute("index", String.valueOf(edge.getIndex()));
            if (edge.getLabel() != null) {
                this.xmlstream.writeAttribute("label", edge.getLabel());
            }
            this.xmlstream.writeEndElement();
        }
    }

    public String toString() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            return new String(((ByteArrayOutputStream)this.outputStream).toByteArray(), Charset.forName("UTF-8"));
        }
        return super.toString();
    }

    public void printToFile(File f) {
        this.close();
        if (this.outputStream instanceof ByteArrayOutputStream) {
            try (FileOutputStream os = new FileOutputStream(f);){
                ((OutputStream)os).write(((ByteArrayOutputStream)this.outputStream).toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void printToSysout() {
        this.close();
        if (this.outputStream instanceof ByteArrayOutputStream) {
            PrintStream out = System.out;
            out.println(this.toString());
        }
    }

    public void printToNetwork(boolean ignoreErrors) {
        block27: {
            this.close();
            if (this.outputStream instanceof ByteArrayOutputStream) {
                try (Socket socket = new Socket(GraphVisualizerAddress, 4444);
                     BufferedOutputStream os = new BufferedOutputStream(socket.getOutputStream(), 16384);){
                    os.write(((ByteArrayOutputStream)this.outputStream).toByteArray());
                }
                catch (IOException e) {
                    if (ignoreErrors) break block27;
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.xmlstream == null) {
            return;
        }
        while (this.openGroupCount > 0) {
            this.endGroup();
        }
        assert (this.openGraphCount == 0 && this.openGroupCount == 0);
        this.xmlstream.writeEndElement();
        this.xmlstream.writeEndDocument();
        this.xmlstream.flush();
        this.xmlstream.close();
        this.xmlstream = null;
    }

    private int nextId() {
        return this.id++;
    }

    private int oldOrNextId(Object node) {
        if (null != this.prevNodeMap && this.prevNodeMap.containsKey(node)) {
            NodeElement nodeElem = this.prevNodeMap.get(node);
            return nodeElem.getId();
        }
        return this.nextId();
    }

    final NodeElement getElementByObject(Object obj) {
        return this.nodeMap.get(obj);
    }

    final void createElementForNode(Object node) {
        boolean exists = this.nodeMap.containsKey(node);
        if (!exists) {
            int nodeId = !exists ? this.oldOrNextId(node) : this.nextId();
            this.nodeMap.put(node, new NodeElement(nodeId));
            String className = NodeUtil.className(node.getClass());
            this.setNodeProperty(node, "name", GraphPrintVisitor.dropNodeSuffix(className));
            NodeInfo nodeInfo = node.getClass().getAnnotation(NodeInfo.class);
            if (nodeInfo != null) {
                this.setNodeProperty(node, "cost", (Object)nodeInfo.cost());
                if (!nodeInfo.shortName().isEmpty()) {
                    this.setNodeProperty(node, "shortName", nodeInfo.shortName());
                }
            }
            this.setNodeProperty(node, "class", className);
            if (node instanceof Node) {
                this.readNodeProperties((Node)node);
                this.copyDebugProperties((Node)node);
            }
        }
    }

    private static String dropNodeSuffix(String className) {
        return className.replaceFirst("Node$", "");
    }

    final void setNodeProperty(Object node, String propertyName, Object value) {
        NodeElement nodeElem = this.getElementByObject(node);
        nodeElem.getProperties().put(propertyName, value);
    }

    private void copyDebugProperties(Node node) {
        Map<String, Object> debugProperties = node.getDebugProperties();
        for (Map.Entry<String, Object> property : debugProperties.entrySet()) {
            this.setNodeProperty(node, property.getKey(), property.getValue());
        }
    }

    private void readNodeProperties(Node node) {
        NodeClass nodeClass = NodeClass.get(node);
        for (Object object : nodeClass.getNodeFields()) {
            if (!GraphPrintVisitor.isDataField(nodeClass, object)) continue;
            String key = nodeClass.getFieldName(object);
            if (this.getElementByObject(node).getProperties().containsKey(key)) continue;
            Object value = nodeClass.getFieldValue(object, node);
            this.setNodeProperty(node, key, value);
        }
    }

    private static boolean isDataField(NodeClass nodeClass, Object field) {
        return !nodeClass.isChildField(field) && !nodeClass.isChildrenField(field);
    }

    final void connectNodes(Object a, Object b, String label) {
        NodeElement fromNode = this.getElementByObject(a);
        NodeElement toNode = this.getElementByObject(b);
        if (fromNode == null || toNode == null) {
            return;
        }
        int count = 0;
        for (EdgeElement e : this.edgeList) {
            if (e.getTo() != toNode) continue;
            ++count;
        }
        this.edgeList.add(new EdgeElement(fromNode, toNode, count, label));
    }

    public GraphPrintVisitor visit(Object node) {
        if (this.openGraphCount == 0) {
            this.beginGraph(DEFAULT_GRAPH_NAME);
        }
        if (this.getElementByObject(node) != null) {
            return this;
        }
        if (!TruffleOptions.AOT && NodeUtil.findAnnotation(node.getClass(), CustomGraphPrintHandler.class) != null) {
            this.visit(node, GraphPrintVisitor.createGraphPrintHandlerFromClass(NodeUtil.findAnnotation(node.getClass(), CustomGraphPrintHandler.class).handler()));
        } else if (NodeUtil.findAnnotation(node.getClass(), NullGraphPrintHandler.class) == null) {
            this.visit(node, new DefaultGraphPrintHandler());
        }
        return this;
    }

    public GraphPrintVisitor visit(Object node, GraphPrintHandler handler) {
        if (this.openGraphCount == 0) {
            this.beginGraph(DEFAULT_GRAPH_NAME);
        }
        handler.visit(node, new GraphPrintAdapter());
        return this;
    }

    private static GraphPrintHandler createGraphPrintHandlerFromClass(Class<? extends GraphPrintHandler> customHandlerClass) {
        try {
            return customHandlerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static LinkedHashMap<String, Node> findNamedNodeChildren(Node node) {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        NodeClass nodeClass = NodeClass.get(node);
        for (Object object : nodeClass.getNodeFields()) {
            Object value;
            if (nodeClass.isChildField(object)) {
                value = nodeClass.getFieldObject(object, node);
                if (value == null) continue;
                nodes.put(nodeClass.getFieldName(object), (Node)value);
                continue;
            }
            if (!nodeClass.isChildrenField(object) || (value = nodeClass.getFieldObject(object, node)) == null) continue;
            Object[] children = (Object[])value;
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null) continue;
                nodes.put(nodeClass.getFieldName(object) + "[" + i + "]", (Node)children[i]);
            }
        }
        return nodes;
    }

    private static String safeToString(Object value) {
        try {
            return String.valueOf(value);
        }
        catch (Throwable ex) {
            return value.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(value));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface NullGraphPrintHandler {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface CustomGraphPrintHandler {
        public Class<? extends GraphPrintHandler> handler();
    }

    private static final class DefaultGraphPrintHandler
    implements GraphPrintHandler {
        private DefaultGraphPrintHandler() {
        }

        @Override
        public void visit(Object node, GraphPrintAdapter printer) {
            printer.createElementForNode(node);
            if (node instanceof Node) {
                for (Map.Entry child : GraphPrintVisitor.findNamedNodeChildren((Node)node).entrySet()) {
                    printer.visit(child.getValue());
                    printer.connectNodes(node, child.getValue(), (String)child.getKey());
                }
            }
        }
    }

    public static interface GraphPrintHandler {
        public void visit(Object var1, GraphPrintAdapter var2);
    }

    public class GraphPrintAdapter {
        public void createElementForNode(Object node) {
            GraphPrintVisitor.this.createElementForNode(node);
        }

        public void visit(Object node) {
            GraphPrintVisitor.this.visit(node);
        }

        public void visit(Object node, GraphPrintHandler handler) {
            GraphPrintVisitor.this.visit(node, handler);
        }

        public void connectNodes(Object node, Object child) {
            GraphPrintVisitor.this.connectNodes(node, child, null);
        }

        public void connectNodes(Object node, Object child, String label) {
            GraphPrintVisitor.this.connectNodes(node, child, label);
        }

        public void setNodeProperty(Object node, String propertyName, Object value) {
            GraphPrintVisitor.this.setNodeProperty(node, propertyName, value);
        }

        public boolean visited(Object node) {
            return GraphPrintVisitor.this.getElementByObject(node) != null;
        }
    }

    private static class XMLImpl
    implements Impl {
        private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
        private final XMLStreamWriter xmlstream;

        XMLImpl(OutputStream outputStream) {
            try {
                this.xmlstream = XML_OUTPUT_FACTORY.createXMLStreamWriter(outputStream);
            }
            catch (FactoryConfigurationError | XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeStartDocument() {
            try {
                this.xmlstream.writeStartDocument();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeEndDocument() {
            try {
                this.xmlstream.writeEndDocument();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeStartElement(String name) {
            try {
                this.xmlstream.writeStartElement(name);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeEndElement() {
            try {
                this.xmlstream.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeAttribute(String name, String value) {
            try {
                this.xmlstream.writeAttribute(name, value);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeCharacters(String text) {
            try {
                this.xmlstream.writeCharacters(text);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void flush() {
            try {
                this.xmlstream.flush();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.xmlstream.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface Impl {
        public void writeStartDocument();

        public void writeEndDocument();

        public void writeStartElement(String var1);

        public void writeEndElement();

        public void writeAttribute(String var1, String var2);

        public void writeCharacters(String var1);

        public void flush();

        public void close();
    }

    private static class EdgeElement {
        private final NodeElement from;
        private final NodeElement to;
        private final int index;
        private final String label;

        EdgeElement(NodeElement from, NodeElement to, int index, String label) {
            this.from = from;
            this.to = to;
            this.index = index;
            this.label = label;
        }

        public NodeElement getFrom() {
            return this.from;
        }

        public NodeElement getTo() {
            return this.to;
        }

        public int getIndex() {
            return this.index;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private static class NodeElement {
        private final int id;
        private final Map<String, Object> properties;

        NodeElement(int id) {
            this.id = id;
            this.properties = new LinkedHashMap<String, Object>();
        }

        public int getId() {
            return this.id;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }
}

