/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.DispatchAction;
import org.jruby.truffle.language.dispatch.DispatchHeadNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.LookupMethodNode;

public abstract class DispatchNode
extends RubyNode {
    private final DispatchAction dispatchAction;
    public static final Object MISSING = new Missing();

    public DispatchNode(RubyContext context, DispatchAction dispatchAction) {
        super(context);
        this.dispatchAction = dispatchAction;
        assert (dispatchAction != null);
    }

    protected abstract boolean guard(Object var1, Object var2);

    protected DispatchNode getNext() {
        return null;
    }

    public abstract Object executeDispatch(VirtualFrame var1, Object var2, Object var3, DynamicObject var4, Object[] var5);

    protected InternalMethod lookup(VirtualFrame frame, Object receiver, String name, boolean ignoreVisibility) {
        return LookupMethodNode.lookupMethodWithVisibility(this.getContext(), frame, receiver, name, ignoreVisibility, this.getHeadNode().onlyCallPublic);
    }

    protected Object resetAndDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects, String reason) {
        DispatchHeadNode head = this.getHeadNode();
        head.reset(reason);
        return head.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    protected DispatchHeadNode getHeadNode() {
        return NodeUtil.findParent(this, DispatchHeadNode.class);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        throw new IllegalStateException("do not call execute on dispatch nodes");
    }

    public DispatchAction getDispatchAction() {
        return this.dispatchAction;
    }

    private static final class Missing {
        private Missing() {
        }
    }
}

