/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.truffle.language.globals.GlobalVariableStorage;

public class GlobalVariables {
    private final DynamicObject defaultValue;
    private final ConcurrentMap<String, GlobalVariableStorage> variables = new ConcurrentHashMap<String, GlobalVariableStorage>();

    public GlobalVariables(DynamicObject defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getOrDefault(String key, Object defaultValue) {
        Object value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public Object get(String key) {
        return this.getStorage(key).getValue();
    }

    @CompilerDirectives.TruffleBoundary
    public GlobalVariableStorage getStorage(String key) {
        return this.variables.computeIfAbsent(key, k -> new GlobalVariableStorage(this.defaultValue));
    }

    public GlobalVariableStorage put(String key, Object value) {
        GlobalVariableStorage storage = this.getStorage(key);
        storage.setValue(value);
        return storage;
    }

    public void alias(String name, GlobalVariableStorage storage) {
        this.variables.put(name, storage);
    }

    public Collection<String> keys() {
        return this.variables.keySet();
    }

    public Collection<DynamicObject> dynamicObjectValues() {
        Collection storages = this.variables.values();
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(storages.size());
        for (GlobalVariableStorage storage : storages) {
            Object value = storage.getValue();
            if (!(value instanceof DynamicObject)) continue;
            values.add((DynamicObject)value);
        }
        return values;
    }
}

