/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.exceptions.RaiseException;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.LoadRequiredLibrariesNode;
import org.jruby.truffle.core.SetTopLevelBindingNode;
import org.jruby.truffle.language.DataNode;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.exceptions.TopLevelRaiseHandler;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.CatchNextNode;
import org.jruby.truffle.language.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.language.methods.CatchReturnAsErrorNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.parser.BodyTranslator;
import org.jruby.truffle.parser.ParseEnvironment;
import org.jruby.truffle.parser.ParserContext;
import org.jruby.truffle.parser.Translator;
import org.jruby.truffle.parser.TranslatorEnvironment;
import org.jruby.truffle.parser.ast.NilParseNode;
import org.jruby.truffle.parser.ast.RootParseNode;
import org.jruby.truffle.parser.parser.Parser;
import org.jruby.truffle.parser.parser.ParserConfiguration;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.truffle.parser.scope.ManyVarsDynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;
import org.jruby.truffle.parser.scope.StaticScopeFactory;

public class TranslatorDriver {
    private final ParseEnvironment parseEnvironment;

    public TranslatorDriver(RubyContext context) {
        this.parseEnvironment = new ParseEnvironment(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RubyRootNode parse(RubyContext context, Source source, Encoding defaultEncoding, ParserContext parserContext, String[] argumentNames, FrameDescriptor frameDescriptor, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode) {
        RubyNode truffleNode;
        RootParseNode node;
        String name;
        TranslatorEnvironment parentEnvironment;
        Parser parser = new Parser(context);
        StaticScopeFactory staticScopeFactory = new StaticScopeFactory(context.getJRubyRuntime());
        StaticScope staticScope = staticScopeFactory.newLocalScope(null);
        if (frameDescriptor != null) {
            for (FrameSlot frameSlot : frameDescriptor.getSlots()) {
                if (!(frameSlot.getIdentifier() instanceof String)) continue;
                String string = (String)frameSlot.getIdentifier();
                staticScope.addVariableThisScope(string.intern());
            }
            parentEnvironment = this.environmentForFrameDescriptor(context, frameDescriptor);
        } else if (parentFrame != null) {
            void var14_15;
            String[] stringArray = parentFrame;
            while (var14_15 != null) {
                for (FrameSlot frameSlot : var14_15.getFrameDescriptor().getSlots()) {
                    if (!(frameSlot.getIdentifier() instanceof String)) continue;
                    name = (String)frameSlot.getIdentifier();
                    staticScope.addVariableThisScope(name.intern());
                }
                MaterializedFrame materializedFrame = RubyArguments.getDeclarationFrame((Frame)var14_15);
            }
            parentEnvironment = this.environmentForFrame(context, (MaterializedFrame)parentFrame);
        } else {
            parentEnvironment = this.environmentForFrame(context, null);
        }
        if (argumentNames != null) {
            void var16_30;
            String[] stringArray = argumentNames;
            int n = stringArray.length;
            boolean bl = false;
            while (var16_30 < n) {
                name = stringArray[var16_30];
                staticScope.addVariableThisScope(name.intern());
                ++var16_30;
            }
        }
        ManyVarsDynamicScope manyVarsDynamicScope = new ManyVarsDynamicScope(staticScope);
        boolean bl = parserContext == ParserContext.SHELL;
        boolean bl2 = parserContext == ParserContext.EVAL || parserContext == ParserContext.INLINE || parserContext == ParserContext.MODULE;
        ParserConfiguration parserConfiguration = new ParserConfiguration(context.getJRubyRuntime(), 0, bl, !bl2, false);
        if (context.getJRubyRuntime().getInstanceConfig().isFrozenStringLiteral()) {
            parserConfiguration.setFrozenStringLiteral(true);
        }
        parserConfiguration.setDefaultEncoding(defaultEncoding);
        try {
            node = (RootParseNode)parser.parse(source.getName(), source.getCode().getBytes(StandardCharsets.UTF_8), (DynamicScope)manyVarsDynamicScope, parserConfiguration);
        }
        catch (RaiseException e) {
            String message = e.getException().getMessage().asJavaString();
            if (message == null) {
                message = "(no message)";
            }
            throw new org.jruby.truffle.language.control.RaiseException(context.getCoreExceptions().syntaxError(message, currentNode));
        }
        SourceSection sourceSection = source.createSection(0, source.getCode().length());
        RubySourceSection rubySourceSection = new RubySourceSection(sourceSection);
        InternalMethod parentMethod = parentFrame == null ? null : RubyArguments.getMethod((Frame)parentFrame);
        LexicalScope lexicalScope = parentMethod != null && parentMethod.getSharedMethodInfo().getLexicalScope() != null ? parentMethod.getSharedMethodInfo().getLexicalScope() : context.getRootLexicalScope();
        if (parserContext == ParserContext.MODULE) {
            Object module = RubyArguments.getSelf(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
            lexicalScope = new LexicalScope(lexicalScope, (DynamicObject)module);
        }
        this.parseEnvironment.resetLexicalScope(lexicalScope);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.parseEnvironment.getLexicalScope(), Arity.NO_ARGUMENTS, "<main>", false, null, false, false, false);
        TranslatorEnvironment environment = new TranslatorEnvironment(context, parentEnvironment, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), ownScopeForAssignments, false, sharedMethodInfo, sharedMethodInfo.getName(), 0, null);
        if (argumentNames != null) {
            for (String name2 : argumentNames) {
                environment.declareVar(name2);
            }
        }
        BodyTranslator translator = new BodyTranslator(currentNode, context, null, environment, source, parserContext == ParserContext.TOP_LEVEL_FIRST || parserContext == ParserContext.TOP_LEVEL);
        if (node.getBodyNode() == null || node.getBodyNode() instanceof NilParseNode) {
            translator.parentSourceSection.push(rubySourceSection);
            try {
                truffleNode = translator.nilNode(source, rubySourceSection);
            }
            finally {
                translator.parentSourceSection.pop();
            }
        } else {
            truffleNode = node.getBodyNode().accept(translator);
        }
        RubyNode writeSelfNode = Translator.loadSelf(context, environment);
        truffleNode = Translator.sequence(context, source, rubySourceSection, Arrays.asList(writeSelfNode, truffleNode));
        if (argumentNames != null && argumentNames.length > 0) {
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            for (int n = 0; n < argumentNames.length; ++n) {
                String name3 = argumentNames[n];
                ProfileArgumentNode readNode = new ProfileArgumentNode(new ReadPreArgumentNode(n, MissingArgumentBehavior.NIL));
                FrameSlot slot = environment.getFrameDescriptor().findFrameSlot(name3);
                sequence.add(WriteLocalVariableNode.createWriteLocalVariableNode(context, sourceSection, slot, (RubyNode)readNode));
            }
            sequence.add(truffleNode);
            truffleNode = Translator.sequence(context, source, rubySourceSection, sequence);
        }
        if (environment.getFlipFlopStates().size() > 0) {
            truffleNode = Translator.sequence(context, source, rubySourceSection, Arrays.asList(translator.initFlipFlopStates(rubySourceSection), truffleNode));
        }
        truffleNode = new CatchNextNode(context, truffleNode.getRubySourceSection().toSourceSection(source), truffleNode);
        if (parserContext != ParserContext.INLINE) {
            truffleNode = new CatchReturnAsErrorNode(context, truffleNode.getRubySourceSection().toSourceSection(source), truffleNode);
        }
        truffleNode = new CatchRetryAsErrorNode(context, truffleNode.getRubySourceSection().toSourceSection(source), truffleNode);
        if (parserContext == ParserContext.TOP_LEVEL_FIRST) {
            truffleNode = Translator.sequence(context, source, rubySourceSection, Arrays.asList(new SetTopLevelBindingNode(context, sourceSection), new LoadRequiredLibrariesNode(context, sourceSection), truffleNode));
            if (node.hasEndPosition()) {
                truffleNode = Translator.sequence(context, source, rubySourceSection, Arrays.asList(new DataNode(context, sourceSection, node.getEndPosition()), truffleNode));
            }
            truffleNode = new ExceptionTranslatingNode(context, sourceSection, truffleNode, UnsupportedOperationBehavior.TYPE_ERROR);
            truffleNode = new TopLevelRaiseHandler(context, sourceSection, truffleNode);
        }
        return new RubyRootNode(context, truffleNode.getRubySourceSection().toSourceSection(source), environment.getFrameDescriptor(), sharedMethodInfo, truffleNode, environment.needsDeclarationFrame());
    }

    private TranslatorEnvironment environmentForFrameDescriptor(RubyContext context, FrameDescriptor frameDescriptor) {
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(context.getCoreLibrary().getSourceSection(), context.getRootLexicalScope(), Arity.NO_ARGUMENTS, "(unknown)", false, null, false, false, false);
        return new TranslatorEnvironment(context, null, this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, true, sharedMethodInfo, sharedMethodInfo.getName(), 0, null, frameDescriptor);
    }

    private TranslatorEnvironment environmentForFrame(RubyContext context, MaterializedFrame frame) {
        if (frame == null) {
            return null;
        }
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(context.getCoreLibrary().getSourceSection(), context.getRootLexicalScope(), Arity.NO_ARGUMENTS, "(unknown)", false, null, false, false, false);
        MaterializedFrame parent = RubyArguments.getDeclarationFrame(frame);
        return new TranslatorEnvironment(context, this.environmentForFrame(context, parent), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, true, sharedMethodInfo, sharedMethodInfo.getName(), 0, null, frame.getFrameDescriptor());
    }
}

