/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class WhileParseNode
extends ParseNode {
    private final ParseNode conditionNode;
    private final ParseNode bodyNode;
    private final boolean evaluateAtStart;

    public WhileParseNode(ISourcePosition position, ParseNode conditionNode, ParseNode bodyNode) {
        this(position, conditionNode, bodyNode, true);
    }

    public WhileParseNode(ISourcePosition position, ParseNode conditionNode, ParseNode bodyNode, boolean evalAtStart) {
        super(position, conditionNode.containsVariableAssignment() || bodyNode.containsVariableAssignment());
        assert (conditionNode != null) : "conditionNode is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.evaluateAtStart = evalAtStart;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHILENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitWhileNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public ParseNode getConditionNode() {
        return this.conditionNode;
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.conditionNode, this.bodyNode);
    }
}

