/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.lexer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.channels.Channel;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.parser.lexer.LexerSource;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelHelper;

public class ByteListLexerSource
extends LexerSource {
    private ByteList completeSource;
    private int offset = 0;

    public ByteListLexerSource(String sourceName, int line, ByteList in, RubyArray list) {
        super(sourceName, line, list);
        this.completeSource = in;
    }

    @Override
    public Encoding getEncoding() {
        return this.completeSource.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding) {
        this.completeSource.setEncoding(encoding);
        this.encodeExistingScriptLines(encoding);
    }

    @Override
    public ByteList gets() {
        int length = this.completeSource.length();
        if (this.offset >= length) {
            return null;
        }
        int end = this.completeSource.indexOf(10, this.offset) + 1;
        if (end == 0) {
            end = length;
        }
        ByteList line = this.completeSource.makeShared(this.offset, end - this.offset);
        this.offset = end;
        if (this.scriptLines != null) {
            this.scriptLines.append((IRubyObject)RubyString.newString((Ruby)this.scriptLines.getRuntime(), (ByteList)line));
        }
        return line;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Channel getRemainingAsChannel() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.completeSource.unsafeBytes(), this.completeSource.begin(), this.completeSource.realSize());
        bais.skip(this.offset);
        return ChannelHelper.readableChannel((InputStream)bais);
    }

    @Override
    public IRubyObject getRemainingAsIO() {
        if (this.scriptLines == null) {
            return null;
        }
        return new RubyIO(this.scriptLines.getRuntime(), this.getRemainingAsChannel());
    }
}

