/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.languagetool.synthesis.ManualSynthesizer;

public class ManualSynthesizerTest {
    private ManualSynthesizer synthesizer;

    @Before
    public void setUp() throws Exception {
        String data = "# some test data\nInflectedForm11\tLemma1\tPOS1\nInflectedForm121\tLemma1\tPOS2\nInflectedForm122\tLemma1\tPOS2\nInflectedForm2\tLemma2\tPOS1\n";
        this.synthesizer = new ManualSynthesizer((InputStream)new ByteArrayInputStream(data.getBytes("UTF-8")));
    }

    @Test
    public void testLookupNonExisting() throws IOException {
        Assert.assertNull((Object)this.synthesizer.lookup("", ""));
        Assert.assertNull((Object)this.synthesizer.lookup("", null));
        Assert.assertNull((Object)this.synthesizer.lookup(null, ""));
        Assert.assertNull((Object)this.synthesizer.lookup(null, null));
        Assert.assertNull((Object)this.synthesizer.lookup("NONE", "UNKNOWN"));
    }

    @Test
    public void testInvalidLookup() throws IOException {
        Assert.assertNull((Object)this.synthesizer.lookup("NONE", "POS1"));
        Assert.assertNull((Object)this.synthesizer.lookup("Lemma1", "UNKNOWN"));
        Assert.assertNull((Object)this.synthesizer.lookup("Lemma1", "POS."));
        Assert.assertNull((Object)this.synthesizer.lookup("Lemma2", "POS2"));
    }

    @Test
    public void testValidLookup() throws IOException {
        Assert.assertEquals((Object)"[InflectedForm11]", (Object)String.valueOf(this.synthesizer.lookup("Lemma1", "POS1")));
        Assert.assertEquals((Object)"[InflectedForm121, InflectedForm122]", (Object)String.valueOf(this.synthesizer.lookup("Lemma1", "POS2")));
        Assert.assertEquals((Object)"[InflectedForm2]", (Object)String.valueOf(this.synthesizer.lookup("Lemma2", "POS1")));
    }

    @Test
    public void testCaseSensitive() throws IOException {
        Assert.assertNull((Object)this.synthesizer.lookup("LEmma1", "POS1"));
    }
}

