/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.util.StringList;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.featuregen.FeatureGeneratorAdapter;

public class CharacterNgramFeatureGenerator
extends FeatureGeneratorAdapter {
    private final int minLength;
    private final int maxLength;

    public CharacterNgramFeatureGenerator(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public CharacterNgramFeatureGenerator() {
        this(2, 5);
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        NGramModel model = new NGramModel();
        model.add(tokens[index], this.minLength, this.maxLength);
        for (StringList tokenList : model) {
            if (tokenList.size() <= 0) continue;
            features.add("ng=" + StringUtil.toLowerCase(tokenList.getToken(0)));
        }
    }
}

