/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.freehep.util.Service;
import org.freehep.util.export.ExportFileType;

class ExportFileTypeRegistry {
    private static ExportFileTypeRegistry registry;
    private ServiceRegistry service = new ServiceRegistry(categories.iterator());
    private static ClassLoader loader;
    private static final Collection categories;

    private ExportFileTypeRegistry() {
        this.addStandardExportFileTypes();
        this.addApplicationClasspathExportFileTypes();
    }

    static ExportFileTypeRegistry getDefaultInstance(ClassLoader loader) {
        if (loader != null) {
            if (ExportFileTypeRegistry.loader != null) {
                throw new RuntimeException(ExportFileTypeRegistry.class.getName() + ": Different classloader was already used in getDefaultInstance");
            }
            ExportFileTypeRegistry.loader = loader;
        }
        if (registry == null) {
            registry = new ExportFileTypeRegistry();
        }
        return registry;
    }

    public List get() {
        return this.get(null);
    }

    public List get(String format) {
        ArrayList<ExportFileType> export = new ArrayList<ExportFileType>();
        Iterator iterator = this.service.getServiceProviders(ExportFileType.class, true);
        block0: while (iterator.hasNext()) {
            ExportFileType type = (ExportFileType)iterator.next();
            if (format == null) {
                export.add(type);
                continue;
            }
            String[] ext = type.getExtensions();
            for (int i = 0; i < ext.length; ++i) {
                if (!ext[i].equals(format)) continue;
                export.add(type);
                continue block0;
            }
        }
        return export;
    }

    private void addStandardExportFileTypes() {
    }

    private void addApplicationClasspathExportFileTypes() {
        ClassLoader classLoader = loader != null ? loader : Thread.currentThread().getContextClassLoader();
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            Class category = (Class)iterator.next();
            Iterator providers = Service.providers(category, classLoader).iterator();
            Object previous = null;
            while (providers.hasNext()) {
                Object current = providers.next();
                this.service.registerServiceProvider(current);
                if (previous != null) {
                    this.service.setOrdering(category, previous, current);
                }
                previous = current;
            }
        }
    }

    public static void main(String[] args) {
        ExportFileTypeRegistry r = ExportFileTypeRegistry.getDefaultInstance(null);
        System.out.println("All ExportFileTypes");
        Iterator providers = r.get().iterator();
        while (providers.hasNext()) {
            System.out.println("   " + providers.next());
        }
        System.out.println("PDF ExportFileTypes");
        providers = r.get("pdf").iterator();
        while (providers.hasNext()) {
            System.out.println("   " + providers.next());
        }
    }

    static {
        categories = new ArrayList(2);
        categories.add(ExportFileType.class);
        categories.add(RegisterableService.class);
    }
}

