/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.log4j.Logger;
import org.zaproxy.zap.Version;
import org.zaproxy.zap.control.AddOnClassnames;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public abstract class BaseZapAddOnXmlData {
    private static final Logger LOGGER = Logger.getLogger(BaseZapAddOnXmlData.class);
    private static final String NAME_ELEMENT = "name";
    private static final String VERSION_ELEMENT = "version";
    private static final String SEM_VER_ELEMENT = "semver";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String AUTHOR_ELEMENT = "author";
    private static final String URL_ELEMENT = "url";
    private static final String CHANGES_ELEMENT = "changes";
    private static final String NOT_BEFORE_VERSION_ELEMENT = "not-before-version";
    private static final String NOT_FROM_VERSION_ELEMENT = "not-from-version";
    private static final String DEPENDENCIES_ELEMENT = "dependencies";
    private static final String DEPENDENCIES_JAVA_VERSION_ELEMENT = "javaversion";
    private static final String DEPENDENCIES_ADDONS_ALL_ELEMENTS = "addons/addon";
    private static final String ZAPADDON_ID_ELEMENT = "id";
    private static final String ZAPADDON_NOT_BEFORE_VERSION_ELEMENT = "not-before-version";
    private static final String ZAPADDON_NOT_FROM_VERSION_ELEMENT = "not-from-version";
    private static final String ZAPADDON_SEMVER_ELEMENT = "semver";
    private static final String EXTENSION_ELEMENT = "extension";
    private static final String EXTENSIONS_ALL_ELEMENTS = "extensions/extension";
    private static final String EXTENSIONS_V1_ALL_ELEMENTS = "extensions/extension[@v='1']";
    private static final String EXTENSION_CLASS_NAME = "classname";
    private static final String EXTENSION_DEPENDENCIES = "dependencies/addons/addon";
    private static final String CLASSNAMES_ALLOWED_ELEMENT = "allowed";
    private static final String CLASSNAMES_ALLOWED_ALL_ELEMENTS = "classnames/allowed";
    private static final String CLASSNAMES_RESTRICTED_ELEMENT = "restricted";
    private static final String CLASSNAMES_RESTRICTED_ALL_ELEMENTS = "classnames/restricted";
    private String name;
    private int packageVersion;
    private Version version;
    private String description;
    private String author;
    private String url;
    private String changes;
    private Dependencies dependencies;
    private AddOnClassnames addOnClassnames;
    private String notBeforeVersion;
    private String notFromVersion;
    private List<String> extensions;
    private List<ExtensionWithDeps> extensionsWithDeps;

    public BaseZapAddOnXmlData(InputStream inputStream) throws IOException {
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration();
        zapXmlConfiguration.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        try {
            zapXmlConfiguration.load(inputStream);
        }
        catch (ConfigurationException configurationException) {
            throw new IOException(configurationException);
        }
        this.readDataImpl((HierarchicalConfiguration)zapXmlConfiguration);
    }

    public BaseZapAddOnXmlData(HierarchicalConfiguration hierarchicalConfiguration) {
        this.readDataImpl(hierarchicalConfiguration);
    }

    private void readDataImpl(HierarchicalConfiguration hierarchicalConfiguration) {
        this.name = hierarchicalConfiguration.getString(NAME_ELEMENT, "");
        this.packageVersion = hierarchicalConfiguration.getInt(VERSION_ELEMENT, 0);
        this.version = BaseZapAddOnXmlData.createVersion(hierarchicalConfiguration.getString("semver", ""));
        this.description = hierarchicalConfiguration.getString(DESCRIPTION_ELEMENT, "");
        this.author = hierarchicalConfiguration.getString(AUTHOR_ELEMENT, "");
        this.url = hierarchicalConfiguration.getString(URL_ELEMENT, "");
        this.changes = hierarchicalConfiguration.getString(CHANGES_ELEMENT, "");
        this.dependencies = this.readDependencies(hierarchicalConfiguration, "zapaddon");
        this.notBeforeVersion = hierarchicalConfiguration.getString("not-before-version", "");
        this.notFromVersion = hierarchicalConfiguration.getString("not-from-version", "");
        this.extensions = this.getStrings(hierarchicalConfiguration, EXTENSIONS_ALL_ELEMENTS, EXTENSION_ELEMENT);
        this.extensionsWithDeps = this.readExtensionsWithDeps(hierarchicalConfiguration);
        this.addOnClassnames = this.readAddOnClassnames(hierarchicalConfiguration);
        this.readAdditionalData(hierarchicalConfiguration);
    }

    protected void readAdditionalData(HierarchicalConfiguration hierarchicalConfiguration) {
    }

    private static Version createVersion(String string) {
        if (!string.isEmpty()) {
            return new Version(string);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getPackageVersion() {
        return this.packageVersion;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getChanges() {
        return this.changes;
    }

    public String getUrl() {
        return this.url;
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    public AddOnClassnames getAddOnClassnames() {
        return this.addOnClassnames;
    }

    public String getNotBeforeVersion() {
        return this.notBeforeVersion;
    }

    public String getNotFromVersion() {
        return this.notFromVersion;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public List<ExtensionWithDeps> getExtensionsWithDeps() {
        return this.extensionsWithDeps;
    }

    protected List<String> getStrings(HierarchicalConfiguration hierarchicalConfiguration, String string, String string2) {
        String[] stringArray = hierarchicalConfiguration.getStringArray(string);
        if (stringArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string3 : stringArray) {
            if (!string3.isEmpty()) {
                arrayList.add(string3);
                continue;
            }
            LOGGER.warn((Object)("Ignoring empty \"" + string2 + "\" entry in add-on \"" + this.name + "\"."));
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return arrayList;
    }

    private Dependencies readDependencies(HierarchicalConfiguration hierarchicalConfiguration, String string) {
        List list = hierarchicalConfiguration.configurationsAt(DEPENDENCIES_ELEMENT);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            this.malformedFile("expected at most one \"dependencies\" element for \"" + string + "\" element, found " + list.size() + ".");
        }
        HierarchicalConfiguration hierarchicalConfiguration2 = (HierarchicalConfiguration)list.get(0);
        String string2 = hierarchicalConfiguration2.getString(DEPENDENCIES_JAVA_VERSION_ELEMENT, "");
        List list2 = hierarchicalConfiguration2.configurationsAt(DEPENDENCIES_ADDONS_ALL_ELEMENTS);
        if (list2.isEmpty()) {
            return new Dependencies(string2, Collections.emptyList());
        }
        List<AddOnDep> list3 = this.readAddOnDependencies(list2);
        return new Dependencies(string2, list3);
    }

    private List<AddOnDep> readAddOnDependencies(List<HierarchicalConfiguration> list) {
        ArrayList<AddOnDep> arrayList = new ArrayList<AddOnDep>(list.size());
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            String string = hierarchicalConfiguration.getString(ZAPADDON_ID_ELEMENT, "");
            if (string.isEmpty()) {
                this.malformedFile("an add-on dependency has empty \"id\".");
            }
            AddOnDep addOnDep = new AddOnDep(string, hierarchicalConfiguration.getString("not-before-version", ""), hierarchicalConfiguration.getString("not-from-version", ""), hierarchicalConfiguration.getString("semver", ""));
            arrayList.add(addOnDep);
        }
        return arrayList;
    }

    private List<ExtensionWithDeps> readExtensionsWithDeps(HierarchicalConfiguration hierarchicalConfiguration) {
        List list = hierarchicalConfiguration.configurationsAt(EXTENSIONS_V1_ALL_ELEMENTS);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExtensionWithDeps> arrayList = new ArrayList<ExtensionWithDeps>(list.size());
        for (HierarchicalConfiguration hierarchicalConfiguration2 : list) {
            List list2;
            String string = hierarchicalConfiguration2.getString(EXTENSION_CLASS_NAME, "");
            if (string.isEmpty()) {
                this.malformedFile("a v1 extension has empty \"classname\".");
            }
            if ((list2 = hierarchicalConfiguration2.configurationsAt(EXTENSION_DEPENDENCIES)).isEmpty()) {
                if (this.extensions.isEmpty()) {
                    this.extensions = new ArrayList<String>(5);
                }
                this.extensions.add(string);
                continue;
            }
            List<AddOnDep> list3 = this.readAddOnDependencies(list2);
            AddOnClassnames addOnClassnames = this.readAddOnClassnames(hierarchicalConfiguration2);
            arrayList.add(new ExtensionWithDeps(string, list3, addOnClassnames));
        }
        return arrayList;
    }

    private AddOnClassnames readAddOnClassnames(HierarchicalConfiguration hierarchicalConfiguration) {
        List<String> list = this.getStrings(hierarchicalConfiguration, CLASSNAMES_ALLOWED_ALL_ELEMENTS, CLASSNAMES_ALLOWED_ELEMENT);
        List<String> list2 = this.getStrings(hierarchicalConfiguration, CLASSNAMES_RESTRICTED_ALL_ELEMENTS, CLASSNAMES_RESTRICTED_ELEMENT);
        if (list.isEmpty() && list2.isEmpty()) {
            return AddOnClassnames.ALL_ALLOWED;
        }
        return new AddOnClassnames(list, list2);
    }

    private void malformedFile(String string) {
        throw new IllegalArgumentException("Add-on \"" + this.name + "\" contains malformed ZapAddOn.xml file, " + string);
    }

    public static class ExtensionWithDeps {
        private final String classname;
        private final List<AddOnDep> addOnDependencies;
        private final AddOnClassnames addOnClassnames;

        public ExtensionWithDeps(String string, List<AddOnDep> list, AddOnClassnames addOnClassnames) {
            this.classname = string;
            this.addOnDependencies = list;
            this.addOnClassnames = addOnClassnames;
        }

        public String getClassname() {
            return this.classname;
        }

        public List<AddOnDep> getDependencies() {
            return this.addOnDependencies;
        }

        public AddOnClassnames getAddOnClassnames() {
            return this.addOnClassnames;
        }
    }

    public static class AddOnDep {
        private final String id;
        private final int notBeforeVersion;
        private final int notFromVersion;
        private final String semVer;

        public AddOnDep(String string, String string2, String string3, String string4) {
            this.id = string;
            this.notBeforeVersion = AddOnDep.convertToInt(string2, -1, "not-before-version");
            this.notFromVersion = AddOnDep.convertToInt(string3, -1, "not-from-version");
            this.semVer = string4;
        }

        private static int convertToInt(String string, int n, String string2) {
            if (string == null || string.isEmpty()) {
                return n;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Expected integer for element \"" + string2 + "\" but was: " + string);
            }
        }

        public String getId() {
            return this.id;
        }

        public int getNotBeforeVersion() {
            return this.notBeforeVersion;
        }

        public int getNotFromVersion() {
            return this.notFromVersion;
        }

        public String getSemVer() {
            return this.semVer;
        }
    }

    public static class Dependencies {
        private final String javaVersion;
        private final List<AddOnDep> addOnDependencies;

        public Dependencies(String string, List<AddOnDep> list) {
            this.javaVersion = string;
            this.addOnDependencies = list;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public List<AddOnDep> getAddOns() {
            return this.addOnDependencies;
        }
    }
}

