/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class VersionFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_version";
    public static final String CONTENT_TYPE = "_version";

    private VersionFieldMapper(Settings indexSettings) {
        super("_version", Defaults.FIELD_TYPE, Defaults.FIELD_TYPE, indexSettings);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        NumericDocValuesField version = new NumericDocValuesField("_version", -1L);
        context.version((Field)version);
        fields.add((Field)version);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        for (int i = 1; i < context.docs().size(); ++i) {
            ParseContext.Document doc = context.docs().get(i);
            doc.add((IndexableField)new NumericDocValuesField("_version", 1L));
        }
    }

    @Override
    protected String contentType() {
        return "_version";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class VersionFieldType
    extends MappedFieldType {
        public VersionFieldType() {
        }

        protected VersionFieldType(VersionFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new VersionFieldType(this);
        }

        @Override
        public String typeName() {
            return "_version";
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "The _version field is not searchable", new Object[0]);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_version is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new VersionFieldMapper(indexSettings);
        }
    }

    public static class Defaults {
        public static final String NAME = "_version";
        public static final MappedFieldType FIELD_TYPE = new VersionFieldType();

        static {
            FIELD_TYPE.setName("_version");
            FIELD_TYPE.setDocValuesType(DocValuesType.NUMERIC);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.freeze();
        }
    }
}

