/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShardOperationsLock
implements Closeable {
    private final ShardId shardId;
    private final Logger logger;
    private final ThreadPool threadPool;
    private static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    @Nullable
    private List<ActionListener<Releasable>> delayedOperations;
    private volatile boolean closed;

    public IndexShardOperationsLock(ShardId shardId, Logger logger, ThreadPool threadPool) {
        this.shardId = shardId;
        this.logger = logger;
        this.threadPool = threadPool;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockOperations(long timeout, TimeUnit timeUnit, Runnable onBlocked) throws InterruptedException, TimeoutException {
        block15: {
            if (this.closed) {
                throw new IndexShardClosedException(this.shardId);
            }
            try {
                if (this.semaphore.tryAcquire(Integer.MAX_VALUE, timeout, timeUnit)) {
                    try {
                        onBlocked.run();
                        break block15;
                    }
                    finally {
                        this.semaphore.release(Integer.MAX_VALUE);
                    }
                }
                throw new TimeoutException("timed out during blockOperations");
            }
            finally {
                List<ActionListener<Releasable>> queuedActions;
                IndexShardOperationsLock indexShardOperationsLock = this;
                synchronized (indexShardOperationsLock) {
                    queuedActions = this.delayedOperations;
                    this.delayedOperations = null;
                }
                if (queuedActions != null) {
                    this.threadPool.executor("generic").execute(() -> {
                        for (ActionListener queuedAction : queuedActions) {
                            this.acquire(queuedAction, null, false);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, boolean forceExecution) {
        Releasable releasable;
        if (this.closed) {
            onAcquired.onFailure(new IndexShardClosedException(this.shardId));
            return;
        }
        try {
            IndexShardOperationsLock indexShardOperationsLock = this;
            synchronized (indexShardOperationsLock) {
                releasable = this.tryAcquire();
                if (releasable == null) {
                    if (this.delayedOperations == null) {
                        this.delayedOperations = new ArrayList<ActionListener<Releasable>>();
                    }
                    if (executorOnDelay != null) {
                        this.delayedOperations.add(new ThreadedActionListener<Releasable>(this.logger, this.threadPool, executorOnDelay, onAcquired, forceExecution));
                    } else {
                        this.delayedOperations.add(onAcquired);
                    }
                    return;
                }
            }
        }
        catch (InterruptedException e) {
            onAcquired.onFailure(e);
            return;
        }
        onAcquired.onResponse(releasable);
    }

    @Nullable
    private Releasable tryAcquire() throws InterruptedException {
        if (this.semaphore.tryAcquire(1, 0L, TimeUnit.SECONDS)) {
            AtomicBoolean closed = new AtomicBoolean();
            return () -> {
                if (closed.compareAndSet(false, true)) {
                    this.semaphore.release(1);
                }
            };
        }
        return null;
    }

    public int getActiveOperationsCount() {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits == 0) {
            return 0;
        }
        return Integer.MAX_VALUE - availablePermits;
    }
}

