/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum PercentilesMethod implements Writeable
{
    TDIGEST("tdigest"),
    HDR("hdr");

    private String name;

    private PercentilesMethod(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static PercentilesMethod readFromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= PercentilesMethod.values().length) {
            throw new IOException("Unknown PercentilesMethod ordinal [" + ordinal + "]");
        }
        return PercentilesMethod.values()[ordinal];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static PercentilesMethod resolveFromName(String name) {
        for (PercentilesMethod method : PercentilesMethod.values()) {
            if (!method.name.equalsIgnoreCase(name)) continue;
            return method;
        }
        return null;
    }
}

