#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.4.3
id: esqueleto-2.4.3-8lVp2FJu5qDLU48ARsHZWh
key: esqueleto-2.4.3-8lVp2FJu5qDLU48ARsHZWh
license: BSD3
copyright: (c) 2012-2015 Felipe Almeida Lessa
maintainer: felipe.lessa@gmail.com
homepage: https://github.com/prowdsponsor/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries
    that works with unmodified @persistent@ SQL backends.  Its
    language closely resembles SQL, so you don'\''t have to learn
    new concepts, just new syntax, and it'\''s fairly easy to
    predict the generated SQL and optimize it for your backend.
    Most kinds of errors committed when writing SQL are caught as
    compile-time errors---although it is possible to write
    type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It
    has many kinds of backends, such as SQL backends
    (@persistent-mysql@, @persistent-postgresql@,
    @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@).
    While @persistent@ is a nice library for storing and retrieving
    records, including with filters, it does not try to support
    some of the features that are specific to SQL backends.  In
    particular, @esqueleto@ is the recommended library for
    type-safe @JOIN@s on @persistent@ SQL backends.  (The
    alternative is using raw SQL, but that'\''s error prone and does
    not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported.
    Not all SQL features are available, but most of them can be easily added
    (especially functions), so please open an issue or send a pull request if
    you need anything that is not covered by @esqueleto@ on
    <https://github.com/prowdsponsor/esqueleto/>.
    .
    The name of this library means \"skeleton\" in Portuguese and
    contains all three SQL letters in the correct order =).  It was
    inspired by Scala'\''s Squeryl but created from scratch.
category: Database
author: Felipe Lessa
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.PostgreSQL
    Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql
hidden-modules: Database.Esqueleto.Internal.PersistentImport
abi: d477da5ca1f0b8ccdfc7dc57976d4d6c
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/esqueleto-2.4.3
library-dirs: /usr/lib/ghc-8.0.1/site-local/esqueleto-2.4.3
data-dir: /usr/share/arm-linux-ghc-8.0.1/esqueleto-2.4.3
hs-libraries: HSesqueleto-2.4.3-8lVp2FJu5qDLU48ARsHZWh
depends:
    base-4.9.0.0 blaze-html-0.8.1.3-9zwPscRNfE2PTZ0oxJGro
    bytestring-0.10.8.1 conduit-1.2.8-BUmkHLfxf6BARU80ZxV0St
    monad-logger-0.3.20-2yBnvNHlevCEuA8leDWrbx
    persistent-2.6-FfHmvc74Y4wEVcoz5lc1fM
    resourcet-1.1.8-809VyiwX9IhH0X7rbGoy6q
    tagged-0.8.5-I7Gu0uzBLkQJCVUvdvwKKq
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ transformers-0.5.2.0
    unordered-containers-0.2.7.1-6Q3w38ZivLTB9nLFgf8RUI
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
