#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: turtle
version: 1.3.0
id: turtle-1.3.0-EfCCEGKyxUdGM3Afr9w8Bt
key: turtle-1.3.0-EfCCEGKyxUdGM3Afr9w8Bt
license: BSD3
copyright: 2015 Gabriel Gonzalez
maintainer: Gabriel439@gmail.com
synopsis: Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.
    .
    Features include:
    .
    * Batteries included: Command an extended suite of predefined utilities
    .
    * Interoperability: You can still run external shell commands
    .
    * Portability: Works on Windows, OS X, and Linux
    .
    * Exception safety: Safely acquire and release resources
    .
    * Streaming: Transform or fold command output in constant space
    .
    * Patterns: Use typed regular expressions that can parse structured values
    .
    * Formatting: Type-safe @printf@-style text formatting
    .
    * Modern: Supports @text@ and @system-filepath@
    .
    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide
    .
    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.
category: System
author: Gabriel Gonzalez
exposed: True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Pattern Turtle.Shell
    Turtle.Options Turtle.Line Turtle.Prelude Turtle.Tutorial
hidden-modules: Turtle.Internal
abi: 9aef658c64d9fa649f10560e93476fd9
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/turtle-1.3.0
library-dirs: /usr/lib/ghc-8.0.1/site-local/turtle-1.3.0
data-dir: /usr/share/arm-linux-ghc-8.0.1/turtle-1.3.0
hs-libraries: HSturtle-1.3.0-EfCCEGKyxUdGM3Afr9w8Bt
depends:
    ansi-wl-pprint-0.6.7.3-BxXaXM4de7bF6SGXMvMtbC
    async-2.1.0-IGx6TJY2BPOHCk3x4WAuIK base-4.9.0.0 bytestring-0.10.8.1
    clock-0.7.2-bxVecpUqndAMeayDi5R9Y directory-1.2.6.2
    foldl-1.2.1-HHube52p2ah8d3vfQ7K1
    hostname-1.0-42Ipmmd3lMbCN35rV9k5gh
    managed-1.0.5-ETX2O5Y4l5T1QoOt8IFXQz
    optional-args-1.0.1-625sLBwIcDc57KxyFFEraW
    optparse-applicative-0.13.0.0-IErSQpKP3j4oJy1jHSvi1 process-1.4.2.0
    stm-2.4.4.1-9HlGYelGmT69YkepeDjuRg
    system-fileio-0.3.16.3-EDef2a4Ximk1z04PLLp95q
    system-filepath-0.4.13.4-24DUGoIUqZu3MxGDhYLfCN
    temporary-1.2.0.4-2ZGJgvUMoC3CqxertnjRxn
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ time-1.6.0.1
    transformers-0.5.2.0 unix-2.7.2.0
    unix-compat-0.4.3.1-GamCWWfiT0318wIeUlpE1K
haddock-interfaces: /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html: /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
