/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayDropTailNode
extends RubyNode {
    final int index;

    public ArrayDropTailNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    @Specialization(guards={"isNullArray(array)"})
    public DynamicObject getHeadNull(DynamicObject array) {
        return this.createArray(null, 0);
    }

    @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject dropTail(DynamicObject array, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile indexLargerThanSize) {
        int size = Layouts.ARRAY.getSize(array);
        if (indexLargerThanSize.profile(this.index >= size)) {
            return this.createArray(null, 0);
        }
        int newSize = size - this.index;
        Object newStore = strategy.newMirror(array).extractRange(0, newSize).getArray();
        return this.createArray(newStore, newSize);
    }
}

