/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.composite;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectArtifactBuilder;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.service.ServiceRegistry;

public class CompositeBuildIdeProjectResolver {
    private final CompositeBuildContext compositeContext;
    private final LocalComponentRegistry registry;
    private final List<ProjectArtifactBuilder> artifactBuilders;

    public CompositeBuildIdeProjectResolver(ServiceRegistry services) {
        this.compositeContext = (CompositeBuildContext)services.get(CompositeBuildContext.class);
        this.registry = (LocalComponentRegistry)services.get(LocalComponentRegistry.class);
        this.artifactBuilders = services.getAll(ProjectArtifactBuilder.class);
    }

    public File getProjectDirectory(ProjectComponentIdentifier projectId) {
        return this.compositeContext.getProjectDirectory(projectId);
    }

    public Set<ProjectComponentIdentifier> getProjectsInComposite() {
        return this.compositeContext.getAllProjects();
    }

    public LocalComponentArtifactMetadata resolveArtifact(ProjectComponentIdentifier project, String type) {
        return this.findArtifact(project, type);
    }

    public File resolveArtifactFile(ProjectComponentIdentifier project, String type) {
        LocalComponentArtifactMetadata artifactMetaData = this.resolveArtifact(project, type);
        if (artifactMetaData == null) {
            return null;
        }
        for (ProjectArtifactBuilder artifactBuilder : this.artifactBuilders) {
            artifactBuilder.build(artifactMetaData);
        }
        return artifactMetaData.getFile();
    }

    private LocalComponentArtifactMetadata findArtifact(ProjectComponentIdentifier project, String type) {
        for (LocalComponentArtifactMetadata artifactMetaData : this.registry.getAdditionalArtifacts(project)) {
            if (!artifactMetaData.getName().getType().equals(type)) continue;
            return artifactMetaData;
        }
        return null;
    }
}

