/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public abstract class DefaultDependencyMetadata
implements DependencyMetadata {
    private final ModuleVersionSelector requested;
    private final Set<IvyArtifactName> artifacts;
    private final List<Artifact> dependencyArtifacts;
    private final ModuleComponentSelector selector;

    protected DefaultDependencyMetadata(ModuleVersionSelector requested, List<Artifact> artifacts) {
        this.requested = requested;
        this.dependencyArtifacts = ImmutableList.copyOf(artifacts);
        this.artifacts = DefaultDependencyMetadata.map(this.dependencyArtifacts);
        this.selector = DefaultModuleComponentSelector.newSelector(requested.getGroup(), requested.getName(), requested.getVersion());
    }

    private static Set<IvyArtifactName> map(List<Artifact> dependencyArtifacts) {
        if (dependencyArtifacts.isEmpty()) {
            return ImmutableSet.of();
        }
        LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)dependencyArtifacts.size());
        for (Artifact artifact : dependencyArtifacts) {
            result.add(artifact.getArtifactName());
        }
        return result;
    }

    @Override
    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata fromConfiguration, ConfigurationMetadata toConfiguration) {
        if (this.dependencyArtifacts.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> includedConfigurations = fromConfiguration.getHierarchy();
        LinkedHashSet artifacts = Sets.newLinkedHashSet();
        for (Artifact depArtifact : this.dependencyArtifacts) {
            IvyArtifactName ivyArtifactName = depArtifact.getArtifactName();
            Set<String> artifactConfigurations = depArtifact.getConfigurations();
            if (!this.include(artifactConfigurations, includedConfigurations)) continue;
            ComponentArtifactMetadata artifact = toConfiguration.artifact(ivyArtifactName);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    protected boolean include(Iterable<String> configurations, Collection<String> acceptedConfigurations) {
        for (String configuration : configurations) {
            if (configuration.equals("*")) {
                return true;
            }
            if (!acceptedConfigurations.contains(configuration)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public DependencyMetadata withRequestedVersion(String requestedVersion) {
        if (requestedVersion.equals(this.requested.getVersion())) {
            return this;
        }
        ModuleVersionSelector newRequested = DefaultModuleVersionSelector.newSelector(this.requested.getGroup(), this.requested.getName(), requestedVersion);
        return this.withRequested(newRequested);
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleVersionSelector requestedVersion = DefaultModuleVersionSelector.newSelector(moduleTarget.getGroup(), moduleTarget.getModule(), moduleTarget.getVersion());
            if (requestedVersion.equals(this.requested)) {
                return this;
            }
            return this.withRequested(requestedVersion);
        }
        if (target instanceof ProjectComponentSelector) {
            ProjectComponentSelector projectTarget = (ProjectComponentSelector)target;
            return new DefaultProjectDependencyMetadata(projectTarget, this);
        }
        throw new IllegalArgumentException("Unexpected selector provided: " + target);
    }

    protected abstract DependencyMetadata withRequested(ModuleVersionSelector var1);

    @Override
    public ComponentSelector getSelector() {
        return this.selector;
    }

    public List<Artifact> getDependencyArtifacts() {
        return this.dependencyArtifacts;
    }
}

