/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.util.GUtil;

public class LocalComponentDependencyMetadata
implements LocalOriginDependencyMetadata {
    private static final Function<ConfigurationMetadata, String> CONFIG_NAME = new Function<ConfigurationMetadata, String>(){

        public String apply(ConfigurationMetadata input) {
            return input.getName();
        }
    };
    private final ComponentSelector selector;
    private final ModuleVersionSelector requested;
    private final String moduleConfiguration;
    private final String dependencyConfiguration;
    private final List<Exclude> excludes;
    private final Set<IvyArtifactName> artifactNames;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final ModuleExclusion exclusions;
    private final Map<String, String> moduleAttributes;

    public LocalComponentDependencyMetadata(ComponentSelector selector, ModuleVersionSelector requested, String moduleConfiguration, Map<String, String> moduleAttributes, String dependencyConfiguration, Set<IvyArtifactName> artifactNames, List<Exclude> excludes, boolean force, boolean changing, boolean transitive) {
        this.selector = selector;
        this.requested = requested;
        this.moduleConfiguration = moduleConfiguration;
        this.moduleAttributes = moduleAttributes;
        this.dependencyConfiguration = dependencyConfiguration;
        this.artifactNames = artifactNames;
        this.excludes = excludes;
        this.exclusions = ModuleExclusions.excludeAny(excludes);
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
    }

    public String toString() {
        return "dependency: " + this.requested + " from-conf: " + this.moduleConfiguration + " to-conf: " + this.dependencyConfiguration;
    }

    @Override
    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public String getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    @Override
    public String getDependencyConfiguration() {
        return LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.dependencyConfiguration);
    }

    @Override
    public Set<ConfigurationMetadata> selectConfigurations(ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent) {
        String targetConfiguration;
        ConfigurationMetadata toConfiguration;
        assert (fromConfiguration.getHierarchy().contains(LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.moduleConfiguration)));
        Map<String, String> attributes = fromConfiguration.getAttributes();
        if (this.dependencyConfiguration == null && !attributes.isEmpty()) {
            Set<String> configurationNames = targetComponent.getConfigurationNames();
            ArrayList<ConfigurationMetadata> candidateConfigurations = new ArrayList<ConfigurationMetadata>(1);
            for (String configurationName : configurationNames) {
                ConfigurationMetadata dependencyConfiguration = targetComponent.getConfiguration(configurationName);
                Map<String, String> dependencyConfigurationAttributes = dependencyConfiguration.getAttributes();
                if (dependencyConfigurationAttributes == null || dependencyConfigurationAttributes.isEmpty() || !dependencyConfigurationAttributes.entrySet().containsAll(attributes.entrySet())) continue;
                candidateConfigurations.add(dependencyConfiguration);
            }
            if (candidateConfigurations.size() == 1) {
                return ImmutableSet.of(candidateConfigurations.get(0));
            }
            if (!candidateConfigurations.isEmpty()) {
                throw new IllegalArgumentException("Cannot choose between the following configurations: " + Sets.newTreeSet((Iterable)Lists.transform(candidateConfigurations, CONFIG_NAME)) + ". All of then match the client attributes " + attributes);
            }
        }
        if ((toConfiguration = targetComponent.getConfiguration(targetConfiguration = (String)GUtil.elvis((Object)this.dependencyConfiguration, (Object)"default"))) == null) {
            throw new ConfigurationNotFoundException(fromComponent.getComponentId(), this.moduleConfiguration, targetConfiguration, targetComponent.getComponentId());
        }
        return ImmutableSet.of((Object)toConfiguration);
    }

    private static String getOrDefaultConfiguration(String configuration) {
        return (String)GUtil.elvis((Object)configuration, (Object)"default");
    }

    @Override
    public Set<String> getModuleConfigurations() {
        return ImmutableSet.of((Object)LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.moduleConfiguration));
    }

    @Override
    public ModuleExclusion getExclusions(ConfigurationMetadata fromConfiguration) {
        assert (fromConfiguration.getHierarchy().contains(LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.moduleConfiguration)));
        return this.exclusions;
    }

    @Override
    public List<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.requested.getVersion();
    }

    @Override
    public Set<ComponentArtifactMetadata> getArtifacts(ConfigurationMetadata fromConfiguration, ConfigurationMetadata toConfiguration) {
        if (this.artifactNames.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ComponentArtifactMetadata> artifacts = new LinkedHashSet<ComponentArtifactMetadata>();
        for (IvyArtifactName artifactName : this.artifactNames) {
            artifacts.add(toConfiguration.artifact(artifactName));
        }
        return artifacts;
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.artifactNames;
    }

    @Override
    public LocalOriginDependencyMetadata withRequestedVersion(String requestedVersion) {
        if (requestedVersion.equals(this.requested.getVersion())) {
            return this;
        }
        ModuleVersionSelector newRequested = DefaultModuleVersionSelector.newSelector(this.requested.getGroup(), this.requested.getName(), requestedVersion);
        ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(newRequested);
        return this.copyWithTarget((ComponentSelector)newSelector, newRequested);
    }

    @Override
    public LocalOriginDependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            ModuleComponentSelector moduleTarget = (ModuleComponentSelector)target;
            ModuleVersionSelector requestedVersion = DefaultModuleVersionSelector.newSelector(moduleTarget.getGroup(), moduleTarget.getModule(), moduleTarget.getVersion());
            if (this.selector.equals(target) && this.requested.equals(requestedVersion)) {
                return this;
            }
            return this.copyWithTarget((ComponentSelector)moduleTarget, requestedVersion);
        }
        if (target instanceof ProjectComponentSelector) {
            if (target.equals(this.selector)) {
                return this;
            }
            return this.copyWithTarget(target, this.requested);
        }
        throw new AssertionError((Object)("Invalid component selector type for substitution: " + target));
    }

    private LocalOriginDependencyMetadata copyWithTarget(ComponentSelector selector, ModuleVersionSelector requested) {
        return new LocalComponentDependencyMetadata(selector, requested, this.moduleConfiguration, this.moduleAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive);
    }
}

