/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache.statistics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutionStatistics {
    private final Map<TaskExecutionOutcome, Integer> taskCounts;
    private final int allTasksCount;
    private final int cacheMissCount;

    public TaskExecutionStatistics(Map<TaskExecutionOutcome, Integer> taskCounts, int cacheMissCount) {
        this.taskCounts = ImmutableMap.copyOf(taskCounts);
        int allTasksCount = 0;
        for (Integer taskCount : taskCounts.values()) {
            allTasksCount += taskCount.intValue();
        }
        this.allTasksCount = allTasksCount;
        this.cacheMissCount = cacheMissCount;
    }

    public int getAllTasksCount() {
        return this.allTasksCount;
    }

    public int getTasksCount(TaskExecutionOutcome outcome) {
        Integer count = this.taskCounts.get((Object)outcome);
        return count == null ? 0 : count;
    }

    public int getCacheMissCount() {
        return this.cacheMissCount;
    }
}

