/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Accessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.SerializationFilterBase;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.org.jdom.Element;

public class SkipDefaultValuesSerializationFilters
extends SerializationFilterBase {
    private final Map<Class<?>, Object> myDefaultBeans = new THashMap();

    @Override
    protected boolean accepts(@NotNull Accessor accessor, @NotNull Object bean, @Nullable Object beanValue) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "accepts"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "org/jetbrains/kotlin/com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "accepts"));
        }
        Object defValue = accessor.read(this.getDefaultBean(bean));
        if (defValue instanceof Element && beanValue instanceof Element) {
            return !JDOMUtil.areElementsEqual((Element)beanValue, (Element)defValue);
        }
        return !Comparing.equal(beanValue, defValue);
    }

    @NotNull
    Object getDefaultBean(@NotNull Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "org/jetbrains/kotlin/com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "getDefaultBean"));
        }
        Class<?> c = bean.getClass();
        Object o = this.myDefaultBeans.get(c);
        if (o == null) {
            o = ReflectionUtil.newInstance(c);
            this.configure(o);
            this.myDefaultBeans.put(c, o);
        }
        Object object = o;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "getDefaultBean"));
        }
        return object;
    }

    protected void configure(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "configure"));
        }
    }
}

