/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="value")})
public abstract class ArrayAppendOneNode
extends RubyNode {
    public ArrayAppendOneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeAppendOne(DynamicObject var1, Object var2);

    @Specialization(guards={"isNullArray(array)", "strategy.specializesFor(value)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject appendOneEmpty(DynamicObject array, Object value, @Cached(value="forValue(value)") ArrayStrategy strategy) {
        ArrayMirror storeMirror = strategy.newArray(1);
        storeMirror.set(0, value);
        Layouts.ARRAY.setStore(array, storeMirror.getArray());
        ArrayHelpers.setSize(array, 1);
        return array;
    }

    @Specialization(guards={"strategy.matches(array)", "strategy.accepts(value)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject appendOneSameType(DynamicObject array, Object value, @Cached(value="of(array, value)") ArrayStrategy strategy, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        ArrayMirror storeMirror = strategy.newMirror(array);
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + 1;
        if (extendProfile.profile(newSize > storeMirror.getLength())) {
            ArrayMirror newStoreMirror = storeMirror.copyArrayAndMirror(ArrayUtils.capacityForOneMore(this.getContext(), storeMirror.getLength()));
            newStoreMirror.set(oldSize, value);
            Layouts.ARRAY.setStore(array, newStoreMirror.getArray());
            ArrayHelpers.setSize(array, newSize);
        } else {
            storeMirror.set(oldSize, value);
            ArrayHelpers.setSize(array, newSize);
        }
        return array;
    }

    @Specialization(guards={"currentStrategy.matches(array)", "!currentStrategy.accepts(value)", "generalizedStrategy.accepts(value)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject appendOneGeneralize(DynamicObject array, Object value, @Cached(value="of(array, value)") ArrayStrategy currentStrategy, @Cached(value="currentStrategy.generalizeFor(value)") ArrayStrategy generalizedStrategy) {
        ArrayMirror currentMirror;
        int oldCapacity;
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + 1;
        int newCapacity = newSize > (oldCapacity = (currentMirror = currentStrategy.newMirror(array)).getLength()) ? ArrayUtils.capacityForOneMore(this.getContext(), oldCapacity) : oldCapacity;
        ArrayMirror storeMirror = generalizedStrategy.newArray(newCapacity);
        currentMirror.copyTo(storeMirror, 0, 0, oldSize);
        storeMirror.set(oldSize, value);
        Layouts.ARRAY.setStore(array, storeMirror.getArray());
        ArrayHelpers.setSize(array, newSize);
        return array;
    }
}

