/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Sprintf;

@JRubyClass(name={"NameError"}, parent="StandardError")
public class RubyNameError
extends RubyException {
    private IRubyObject name;
    private IRubyObject receiver;
    private static final ObjectAllocator NAMEERROR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNameError(runtime, klass);
        }
    };

    static RubyClass createNameErrorClass(Ruby runtime, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime.defineClass("NameError", standardErrorClass, NAMEERROR_ALLOCATOR);
        nameErrorClass.defineAnnotatedMethods(RubyNameError.class);
        return nameErrorClass;
    }

    static RubyClass createNameErrorMessageClass(Ruby runtime, RubyClass nameErrorClass) {
        RubyClass messageClass = nameErrorClass.defineClassUnder("Message", runtime.getClass("Data"), RubyNameErrorMessage.ALLOCATOR);
        messageClass.defineAnnotatedMethods(RubyNameErrorMessage.class);
        return messageClass;
    }

    protected RubyNameError(Ruby runtime, RubyClass exceptionClass) {
        this(runtime, exceptionClass, exceptionClass.getName());
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message2) {
        this(runtime, exceptionClass, message2, (String)null);
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message2, String name2) {
        super(runtime, exceptionClass, message2);
        this.name = name2 == null ? runtime.getNil() : runtime.newString(name2);
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message2, IRubyObject name2) {
        super(runtime, exceptionClass, message2);
        this.name = name2;
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv2) {
        return RubyNameError.newNameError(recv2, NULL_ARRAY);
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static RubyException exception(ThreadContext context, IRubyObject recv2, IRubyObject message2) {
        return RubyNameError.newNameError(recv2, new IRubyObject[]{message2});
    }

    @JRubyMethod(name={"exception"}, meta=true)
    public static RubyException exception(ThreadContext context, IRubyObject recv2, IRubyObject message2, IRubyObject name2) {
        return RubyNameError.newNameError(recv2, message2, name2);
    }

    private static RubyException newNameError(IRubyObject recv2, IRubyObject[] args2) {
        RubyClass klass = (RubyClass)recv2;
        RubyException newError = (RubyException)klass.allocate();
        newError.callInit(args2, Block.NULL_BLOCK);
        return newError;
    }

    static RubyException newNameError(IRubyObject recv2, IRubyObject message2, IRubyObject name2) {
        RubyClass klass = (RubyClass)recv2;
        RubyException newError = (RubyException)klass.allocate();
        newError.callInit(message2, name2, Block.NULL_BLOCK);
        return newError;
    }

    @Override
    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        if (args2.length > 0) {
            this.setMessage(args2[0]);
        }
        if (this.getMessage() instanceof RubyNameErrorMessage) {
            this.receiver = ((RubyNameErrorMessage)this.getMessage()).object;
        }
        this.name = args2.length > 1 ? args2[1] : this.getRuntime().getNil();
        super.initialize(NULL_ARRAY, block);
        return this;
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        if (this.getMessage().isNil()) {
            return context.runtime.newString(this.getMetaClass().getRealClass().getName());
        }
        RubyString str = this.getMessage().convertToString();
        if (str != this.getMessage()) {
            this.setMessage(str);
        }
        return this.getMessage();
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.name;
    }

    @JRubyMethod
    public IRubyObject receiver(ThreadContext context) {
        if (this.receiver != null) {
            return this.receiver;
        }
        throw context.runtime.newArgumentError("no receiver is available");
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        super.copySpecialInstanceVariables(clone2);
        RubyNameError exception2 = (RubyNameError)clone2;
        exception2.name = this.name;
    }

    @JRubyClass(name={"NameError::Message"}, parent="Data")
    public static final class RubyNameErrorMessage
    extends RubyObject {
        private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new RubyNameErrorMessage(runtime);
            }
        };
        private String message;
        private IRubyObject object;
        private IRubyObject name;

        RubyNameErrorMessage(Ruby runtime) {
            super(runtime, runtime.getNameErrorMessage());
        }

        RubyNameErrorMessage(Ruby runtime, String message2, IRubyObject object, IRubyObject name2) {
            super(runtime, runtime.getNameErrorMessage(), false);
            this.message = message2;
            this.object = object;
            this.name = name2;
        }

        @JRubyMethod(name={"_load"}, meta=true)
        public static IRubyObject load(IRubyObject recv2, IRubyObject arg2) {
            return arg2;
        }

        @JRubyMethod(name={"_dump"})
        public IRubyObject dump(ThreadContext context, IRubyObject arg2) {
            return this.to_str(context);
        }

        @JRubyMethod
        public IRubyObject to_str(ThreadContext context) {
            String separator;
            Ruby runtime = context.runtime;
            if (this.message == null) {
                return context.nil;
            }
            String description = null;
            String className = null;
            boolean singleton = false;
            if (this.object.isNil()) {
                description = "nil";
            } else if (this.object instanceof RubyBoolean && this.object.isTrue()) {
                description = "true";
            } else if (this.object instanceof RubyBoolean && !this.object.isTrue()) {
                description = "false";
            } else {
                try {
                    description = RubyObject.inspect(context, this.object).toString();
                }
                catch (JumpException e) {
                    context.setErrorInfo(context.nil);
                }
                if (description == null || description.length() > 65) {
                    description = this.object.anyToString().toString();
                }
                boolean bl = singleton = description.length() > 0 && description.charAt(0) == '#';
            }
            if (!singleton) {
                separator = ":";
                className = this.object.getMetaClass().getRealClass().getName();
            } else {
                separator = "";
                className = "";
            }
            RubyArray arr = RubyArray.newArray(runtime, this.name, runtime.newString(description), runtime.newString(separator), runtime.newString(className));
            ByteList msgBytes = new ByteList(this.message.length() + description.length() + this.name.toString().length());
            Sprintf.sprintf(msgBytes, this.message, (IRubyObject)arr);
            return runtime.newString(msgBytes);
        }
    }
}

