/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.internal;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.java.model.internal.AnnotationUtil;
import org.jetbrains.kotlin.java.model.internal.InternalUtilKt;
import org.jetbrains.kotlin.java.model.internal.KotlinAnnotationProxyMaker;
import org.jetbrains.kotlin.java.model.internal.MirroredTypeExceptionProxy;
import org.jetbrains.kotlin.java.model.internal.MirroredTypesExceptionProxy;
import org.jetbrains.kotlin.java.model.types.JeTypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0001\n\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a.\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0016H\u0002\u001a\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\u001f\u001a\u00020 2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010!\u001a\u00020\"2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0010\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a\u0010\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006%"}, d2={"JAVA_LANG_STRING", "", "fqName", "Lcom/intellij/psi/PsiType;", "getFqName", "(Lcom/intellij/psi/PsiType;)Ljava/lang/String;", "booleanValue", "", "value", "", "byteValue", "", "castPrimitiveValue", "type", "charValue", "", "doubleValue", "", "floatValue", "", "getConstantValue", "psiValue", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "returnType", "jReturnType", "Ljava/lang/Class;", "evaluator", "Lcom/intellij/psi/PsiConstantEvaluationHelper;", "getObjectType", "intValue", "", "longValue", "", "shortValue", "", "unexpectedType", "", "annotation-processing"})
public final class KotlinAnnotationProxyMakerKt {
    private static final String JAVA_LANG_STRING = "java.lang.String";

    /*
     * WARNING - void declaration
     */
    private static final Object getConstantValue(PsiAnnotationMemberValue psiValue, PsiType returnType, Class<?> jReturnType, PsiConstantEvaluationHelper evaluator) {
        Object object;
        PsiManager manager = psiValue.getManager();
        if (Intrinsics.areEqual((Object)returnType, (Object)PsiType.NULL) || Intrinsics.areEqual((Object)returnType, (Object)PsiType.VOID)) {
            Void void_ = KotlinAnnotationProxyMakerKt.unexpectedType("void");
            throw null;
        }
        if (Intrinsics.areEqual((Object)KotlinAnnotationProxyMakerKt.getFqName(returnType), (Object)JAVA_LANG_STRING)) {
            PsiAnnotationMemberValue psiAnnotationMemberValue = psiValue;
            if (!(psiAnnotationMemberValue instanceof PsiExpression)) {
                psiAnnotationMemberValue = null;
            }
            PsiExpression psiExpression = (PsiExpression)psiAnnotationMemberValue;
            return psiExpression != null ? InternalUtilKt.calcConstantValue(psiExpression, evaluator) : null;
        }
        if (jReturnType.isAnnotation()) {
            if (!(psiValue instanceof PsiAnnotation)) {
                String string = "psiValue is not a PsiAnnotation";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)returnType);
            if (psiClass == null) {
                String string = "Can't resolve type " + returnType;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            PsiClass annotationClass = psiClass;
            PsiAnnotation psiAnnotation = (PsiAnnotation)psiValue;
            PsiClass psiClass2 = annotationClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"annotationClass");
            Class<?> clazz = jReturnType;
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out kotlin.Annotation>");
            }
            KotlinAnnotationProxyMaker annotation = new KotlinAnnotationProxyMaker(psiAnnotation, psiClass2, clazz);
            return jReturnType.cast(annotation.generate());
        }
        if (jReturnType.isArray()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            List arrayValues;
            Class<?> clazz = jReturnType.getComponentType();
            if (clazz == null) {
                Void void_ = KotlinAnnotationProxyMakerKt.unexpectedType("no component type for " + jReturnType);
                throw null;
            }
            Class<?> jComponentType = clazz;
            if (!(returnType instanceof PsiArrayType)) {
                Void void_ = KotlinAnnotationProxyMakerKt.unexpectedType(returnType);
                throw null;
            }
            PsiAnnotationMemberValue psiAnnotationMemberValue = psiValue;
            List list = arrayValues = psiAnnotationMemberValue instanceof PsiArrayInitializerMemberValue ? ArraysKt.toList((Object[])((PsiArrayInitializerMemberValue)psiValue).getInitializers()) : CollectionsKt.listOf((Object)psiValue);
            if (jComponentType.isPrimitive() || jComponentType.isAnnotation() || jComponentType.isEnum() || Intrinsics.areEqual((Object)jComponentType.getCanonicalName(), (Object)JAVA_LANG_STRING)) {
                void $receiver$iv;
                Object arr = Array.newInstance(jComponentType, arrayValues.size());
                Iterable iterable = arrayValues;
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void componentPsiValue;
                    int n = index$iv++;
                    PsiAnnotationMemberValue psiAnnotationMemberValue2 = (PsiAnnotationMemberValue)item$iv;
                    int i = n;
                    void v12 = componentPsiValue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"componentPsiValue");
                    PsiType psiType = ((PsiArrayType)returnType).getComponentType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"returnType.componentType");
                    Object componentValue = KotlinAnnotationProxyMakerKt.getConstantValue((PsiAnnotationMemberValue)v12, psiType, jComponentType, evaluator);
                    try {
                        Array.set(arr, i, componentValue);
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
                return arr;
            }
            Iterable $receiver$iv = arrayValues;
            Iterable index$iv = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                PsiAnnotationMemberValue i = (PsiAnnotationMemberValue)item$iv$iv;
                void var18_29 = destination$iv$iv;
                void v14 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"it");
                PsiType psiType = KotlinAnnotationProxyMakerKt.getObjectType((PsiAnnotationMemberValue)v14);
                PsiManager psiManager = manager;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"manager");
                TypeMirror typeMirror = JeTypeUtils.toJeType$default(psiType, psiManager, false, 2, null);
                var18_29.add(typeMirror);
            }
            List typeMirrors = (List)destination$iv$iv;
            return new MirroredTypesExceptionProxy(Collections.unmodifiableList(typeMirrors));
        }
        if (jReturnType.isEnum()) {
            PsiElement psiElement = psiValue.getOriginalElement();
            if (!(psiElement instanceof PsiReference)) {
                psiElement = null;
            }
            PsiReference psiReference = (PsiReference)psiElement;
            Object object2 = psiReference != null ? psiReference.resolve() : null;
            if (!(object2 instanceof PsiEnumConstant)) {
                object2 = null;
            }
            PsiEnumConstant psiEnumConstant = (PsiEnumConstant)object2;
            if (psiEnumConstant == null) {
                String string = psiValue + " can not be resolved to enum constant";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            PsiEnumConstant enumConstant = psiEnumConstant;
            return AnnotationUtil.createEnumValue(jReturnType, enumConstant.getName());
        }
        if (returnType instanceof PsiClassType) {
            PsiType psiType = KotlinAnnotationProxyMakerKt.getObjectType(psiValue);
            PsiManager psiManager = manager;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"manager");
            TypeMirror type = JeTypeUtils.toJeType$default(psiType, psiManager, false, 2, null);
            object = new MirroredTypeExceptionProxy(type);
        } else {
            PsiAnnotationMemberValue psiAnnotationMemberValue = psiValue;
            if (!(psiAnnotationMemberValue instanceof PsiExpression)) {
                psiAnnotationMemberValue = null;
            }
            PsiExpression psiExpression = (PsiExpression)psiAnnotationMemberValue;
            object = KotlinAnnotationProxyMakerKt.castPrimitiveValue(returnType, psiExpression != null ? InternalUtilKt.calcConstantValue(psiExpression, evaluator) : null);
        }
        return object;
    }

    private static final String getFqName(@NotNull PsiType $receiver) {
        PsiClassType psiClassType;
        PsiType psiType = $receiver;
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        return (psiClassType = (PsiClassType)psiType) != null && (psiClassType = psiClassType.resolve()) != null ? psiClassType.getQualifiedName() : null;
    }

    private static final PsiType getObjectType(PsiAnnotationMemberValue value) {
        PsiAnnotationMemberValue psiAnnotationMemberValue = value;
        if (psiAnnotationMemberValue instanceof PsiClassObjectAccessExpression) {
            PsiType psiType = ((PsiClassObjectAccessExpression)value).getOperand().getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"value.operand.type");
            return psiType;
        }
        if (psiAnnotationMemberValue instanceof PsiReference) {
            PsiExpression initializer;
            PsiElement resolvedElement = ((PsiReference)value).resolve();
            if (resolvedElement instanceof PsiField && InternalUtilKt.isStatic((PsiModifierListOwner)resolvedElement) && InternalUtilKt.isFinal((PsiModifierListOwner)resolvedElement) && (initializer = ((PsiField)resolvedElement).getInitializer()) != null) {
                return KotlinAnnotationProxyMakerKt.getObjectType((PsiAnnotationMemberValue)initializer);
            }
            throw (Throwable)new IllegalStateException("Can't resolve a reference " + value.getClass() + ": " + value.getText() + " (in " + value.getParent().getText() + ")");
        }
        throw (Throwable)new IllegalArgumentException("Illegal value type: " + value.getClass());
    }

    private static final Object castPrimitiveValue(PsiType type, Object value) {
        Comparable<Byte> comparable;
        PsiType psiType = type;
        if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.BYTE)) {
            comparable = KotlinAnnotationProxyMakerKt.byteValue(value);
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.SHORT)) {
            comparable = KotlinAnnotationProxyMakerKt.shortValue(value);
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.INT)) {
            comparable = KotlinAnnotationProxyMakerKt.intValue(value);
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.CHAR)) {
            comparable = Character.valueOf(KotlinAnnotationProxyMakerKt.charValue(value));
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.BOOLEAN)) {
            comparable = KotlinAnnotationProxyMakerKt.booleanValue(value);
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.LONG)) {
            comparable = KotlinAnnotationProxyMakerKt.longValue(value);
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.FLOAT)) {
            comparable = Float.valueOf(KotlinAnnotationProxyMakerKt.floatValue(value));
        } else if (Intrinsics.areEqual((Object)psiType, (Object)PsiType.DOUBLE)) {
            comparable = KotlinAnnotationProxyMakerKt.doubleValue(value);
        } else {
            Void void_ = KotlinAnnotationProxyMakerKt.unexpectedType(type);
            throw null;
        }
        return comparable;
    }

    private static final byte byteValue(Object value) {
        Object object = value;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        return number != null ? number.byteValue() : (byte)0;
    }

    private static final int intValue(Object value) {
        Object object = value;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        return number != null ? number.intValue() : 0;
    }

    private static final short shortValue(Object value) {
        Object object = value;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        return number != null ? number.shortValue() : (short)0;
    }

    private static final boolean booleanValue(Object value) {
        return Intrinsics.areEqual((Object)value, (Object)true);
    }

    private static final char charValue(Object value) {
        Object object = value;
        if (!(object instanceof Character)) {
            object = null;
        }
        Character c = (Character)object;
        return c != null ? c.charValue() : (char)0;
    }

    private static final long longValue(Object value) {
        Object object = value;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        return number != null ? number.longValue() : 0L;
    }

    private static final float floatValue(Object value) {
        Object object = value;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        return number != null ? number.floatValue() : 0.0f;
    }

    private static final double doubleValue(Object value) {
        Object object = value;
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        return number != null ? number.doubleValue() : 0.0;
    }

    private static final Void unexpectedType(String type) {
        String string = "Unexpected type: " + type;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private static final Void unexpectedType(PsiType type) {
        String string = type.getPresentableText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.presentableText");
        Void void_ = KotlinAnnotationProxyMakerKt.unexpectedType(string);
        throw null;
    }

    static {
        JAVA_LANG_STRING = JAVA_LANG_STRING;
    }

    @NotNull
    public static final /* synthetic */ Void access$unexpectedType(@NotNull String type) {
        return KotlinAnnotationProxyMakerKt.unexpectedType(type);
    }

    @Nullable
    public static final /* synthetic */ Object access$getConstantValue(@NotNull PsiAnnotationMemberValue psiValue, @NotNull PsiType returnType, @NotNull Class jReturnType, @NotNull PsiConstantEvaluationHelper evaluator) {
        return KotlinAnnotationProxyMakerKt.getConstantValue(psiValue, returnType, jReturnType, evaluator);
    }
}

