/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.tree;

import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.BaseFrame;
import ch.softenvironment.view.tree.AutoScrollingTree;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class TreeDropTarget
implements DropTargetListener {
    private AutoScrollingTree targetTree = null;

    public TreeDropTarget(AutoScrollingTree tree) {
        this.targetTree = tree;
        new DropTarget(this.targetTree, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point pt = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath parentpath = tree.getClosestPathForLocation(pt.x, pt.y);
        Object target = parentpath.getLastPathComponent();
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            if (flavors.length == 1 && tr.isDataFlavorSupported(flavors[0]) && dtde.getDropAction() == 2) {
                TreePath p = (TreePath)tr.getTransferData(flavors[0]);
                Object sourceNode = p.getLastPathComponent();
                String msg = this.targetTree.getUtility().isAddable(sourceNode, target);
                if (msg == null) {
                    if (BaseDialog.showConfirm(this.targetTree, ResourceManager.getResource(TreeDropTarget.class, "CTMoveConfirm"), ResourceManager.getResource(TreeDropTarget.class, "CIMoveConfirm"))) {
                        dtde.acceptDrop(dtde.getDropAction());
                        dtde.dropComplete(true);
                        this.targetTree.getUtility().relocateElement(sourceNode, target);
                    } else {
                        dtde.rejectDrop();
                    }
                } else {
                    dtde.rejectDrop();
                    BaseDialog.showWarning(this.targetTree, null, msg);
                }
            } else {
                dtde.rejectDrop();
            }
        }
        catch (Throwable e) {
            dtde.rejectDrop();
            BaseFrame.showException(this.targetTree, e);
        }
    }
}

