/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AssociationEnd;
import com.ibm.xmi.framework.Attribute;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Feature;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.SchemaConstructWriter;
import com.ibm.xmi.framework.XMIClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class ClassS20Writer
extends SchemaConstructWriter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public ClassS20Writer(Object object) {
        super(object);
    }

    protected ArrayList documentationFromFeatures(Object object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object instanceof XMIClass) {
            Iterator iterator = ((XMIClass)object).getXMIFeatures().iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                String string = this.getDocumentation(this.getSource(feature));
                if (string == null) continue;
                if (feature instanceof Attribute) {
                    arrayList.add("ATTRIBUTE: " + this.stripNamespace(this.wrapper.getXMIName(feature)));
                } else if (feature instanceof AssociationEnd) {
                    arrayList.add("ASSOCIATION END: " + this.stripNamespace(this.wrapper.getXMIName(feature)));
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public void write(int n, int n2) throws Exception {
        Data data;
        Object object;
        Collection collection;
        String[] stringArray;
        super.write(n, n2);
        Object object2 = this.getDefinition();
        if (!this.equalsNamespace(object2)) {
            return;
        }
        String string = this.getDocumentation();
        if (string == null) {
            this.printComment(n, n2, "CLASS: " + this.stripNamespace(this.wrapper.getXMIName(object2)));
        } else {
            stringArray = new ArrayList();
            stringArray.add("CLASS: " + this.stripNamespace(this.wrapper.getXMIName(object2)));
            stringArray.add(string);
            collection = this.documentationFromFeatures(object2);
            stringArray.addAll(collection);
            this.printComment(n, n2, (ArrayList)stringArray);
        }
        PrintXML.printBlankLine();
        stringArray = new String[]{"name", this.stripNamespace(this.wrapper.getXMIName(object2))};
        PrintXML.printStartElement("xsd:complexType", stringArray, false, n);
        this.printStartChoice(n + n2);
        collection = this.wrapper.getAllFeatures(object2);
        Iterator iterator = this.wrapper.getProperties(collection).iterator();
        while (iterator.hasNext()) {
            object = (Data)iterator.next();
            if (this.wrapper.getType(object) == 7) {
                stringArray = new String[]{"name", this.stripNamespace(this.wrapper.getXMIName(object)), "type", "xsd:string", "nillable", "true"};
                PrintXML.printStartElement("xsd:element", stringArray, true, n + n2 * 2);
                continue;
            }
            if (this.wrapper.getType(object) == 6) {
                stringArray = new String[]{"name", this.stripNamespace(this.wrapper.getXMIName(object)), "type", this.stripIfSN(this.wrapper.getFeatureType(object)), "nillable", "true"};
                PrintXML.printStartElement("xsd:element", stringArray, true, n + n2 * 2);
                continue;
            }
            if (this.wrapper.getType(object) != 8) continue;
            stringArray = new String[]{"name", this.stripNamespace(this.wrapper.getXMIName(object)), "type", "xmi:Any"};
            PrintXML.printStartElement("xsd:element", stringArray, true, n + n2 * 2);
        }
        object = this.wrapper.getLinks(collection).iterator();
        while (object.hasNext()) {
            data = (Data)object.next();
            stringArray = new String[]{"name", this.stripNamespace(this.wrapper.getXMIName(data)), "type", "xmi:Any"};
            PrintXML.printStartElement("xsd:element", stringArray, true, n + n2 * 2);
        }
        this.printElementRef("xmi:Extension", n + n2 * 2);
        PrintXML.printEndElement("xsd:choice", n + n2);
        this.printAttributeRef("xmi:id", n + n2);
        this.printAttributeGroupRef("xmi:ObjectAttribs", n + n2);
        iterator = this.wrapper.getProperties(collection).iterator();
        while (iterator.hasNext()) {
            data = (Data)iterator.next();
            if (this.wrapper.getType(data) == 7) {
                this.printAttribute(this.stripNamespace(this.wrapper.getXMIName(data)), "xsd:string", n + n2);
                continue;
            }
            if (this.wrapper.getType(data) != 6) continue;
            this.printAttribute(this.stripNamespace(this.wrapper.getXMIName(data)), this.stripNamespace(this.wrapper.getXMIName(this.wrapper.getFeatureType(data))), n + n2);
        }
        object = this.wrapper.getLinks(collection).iterator();
        while (object.hasNext()) {
            data = (Data)object.next();
            String string2 = this.stripNamespace(this.wrapper.getXMIName(data));
            if (this.wrapper.getType(data) == 4) continue;
            this.printAttribute(string2, "xsd:IDREFS", n + n2);
        }
        PrintXML.printEndElement("xsd:complexType", n);
        PrintXML.printBlankLine();
        stringArray = new String[]{"name", this.stripNamespace(this.wrapper.getXMIName(object2)), "type", this.stripNamespace(this.wrapper.getXMIName(object2))};
        PrintXML.printStartElement("xsd:element", stringArray, true, n);
        PrintXML.printBlankLine();
    }
}

