/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XIMStringConversionText
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 16;
    }

    @Override
    public int getDataSize() {
        return XIMStringConversionText.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XIMStringConversionText(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XIMStringConversionText() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XIMStringConversionText.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public short get_length() {
        log.finest("");
        return Native.getShort(this.pData + 0L);
    }

    public void set_length(short v) {
        log.finest("");
        Native.putShort(this.pData + 0L, v);
    }

    public long get_feedback(int index) {
        log.finest("");
        return Native.getLong(this.pData + 4L) + (long)(index * Native.getLongSize());
    }

    public long get_feedback() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_feedback(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    public boolean get_encoding_is_wchar() {
        log.finest("");
        return Native.getBool(this.pData + 8L);
    }

    public void set_encoding_is_wchar(boolean v) {
        log.finest("");
        Native.putBool(this.pData + 8L, v);
    }

    public long get_string(int index) {
        log.finest("");
        return Native.getLong(this.pData + 12L) + (long)(index * Native.getLongSize());
    }

    public long get_string() {
        log.finest("");
        return Native.getLong(this.pData + 12L);
    }

    public void set_string(long v) {
        log.finest("");
        Native.putLong(this.pData + 12L, v);
    }

    @Override
    String getName() {
        return "XIMStringConversionText";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(160);
        ret.append("length = ").append(this.get_length()).append(", ");
        ret.append("feedback = ").append(this.get_feedback()).append(", ");
        ret.append("encoding_is_wchar = ").append(this.get_encoding_is_wchar()).append(", ");
        ret.append("string = ").append(this.get_string()).append(", ");
        return ret.toString();
    }
}

