/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    MenuItem selectedItem;
    Decorations parent;
    int imItem;
    int imSeparator;
    int imHandle;
    ImageList imageList;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        super(decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.createWidget(0);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean bl) {
        if (bl == this.gtk_widget_get_mapped(this.handle)) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                if ((this.parent._getShell().style & 0x4000) != 0) {
                    OS.gtk_menu_shell_set_take_focus(this.handle, false);
                }
                int n = this.hasLocation ? this.display.menuPositionProc : 0;
                this.hasLocation = false;
                int n2 = 0;
                TrayItem trayItem = this.display.currentTrayItem;
                if (trayItem != null && !trayItem.isDisposed()) {
                    n2 = trayItem.handle;
                    n = OS.gtk_status_icon_position_menu_func();
                }
                OS.gtk_menu_popup(this.handle, 0, 0, n, n2, 0, this.display.getLastEventTime());
            } else {
                this.sendEvent(23);
            }
        } else {
            OS.gtk_menu_popdown(this.handle);
        }
    }

    void addAccelerators(int n) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.addAccelerators(n);
        }
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        if ((this.style & 2) != 0) {
            this.handle = OS.gtk_menu_bar_new();
            if (this.handle == 0) {
                this.error(2);
            }
            int n2 = this.parent.vboxHandle;
            OS.gtk_container_add(n2, this.handle);
            OS.gtk_box_set_child_packing(n2, this.handle, false, true, 0, 0);
        } else {
            this.handle = OS.gtk_menu_new();
            if (this.handle == 0) {
                this.error(2);
            }
        }
    }

    void createIMMenu(int n) {
        Object[] objectArray;
        boolean bl = false;
        int n2 = OS.gtk_settings_get_default();
        if (n2 != 0 && OS.GTK_VERSION < OS.VERSION(3, 10, 0)) {
            objectArray = new int[1];
            OS.g_object_get(n2, OS.gtk_show_input_method_menu, objectArray, 0);
            boolean bl2 = bl = objectArray[0] != 0;
        }
        if (n == 0 || !bl) {
            this.imHandle = 0;
            if (this.imItem != 0) {
                OS.gtk_widget_destroy(this.imItem);
                this.imItem = 0;
            }
            if (this.imSeparator != 0) {
                OS.gtk_widget_destroy(this.imSeparator);
                this.imSeparator = 0;
            }
            return;
        }
        if (this.imHandle == n) {
            return;
        }
        this.imHandle = n;
        if (this.imSeparator == 0) {
            this.imSeparator = OS.gtk_separator_menu_item_new();
            OS.gtk_widget_show(this.imSeparator);
            OS.gtk_menu_shell_insert(this.handle, this.imSeparator, -1);
        }
        if (this.imItem == 0) {
            objectArray = Converter.wcsToMbcs(null, SWT.getMessage("SWT_InputMethods"), true);
            if (OS.GTK3) {
                this.imItem = OS.gtk_menu_item_new();
                if (this.imItem == 0) {
                    this.error(2);
                }
                int n3 = 0;
                int n4 = OS.gtk_accel_label_new((byte[])objectArray);
                if (n4 == 0) {
                    this.error(2);
                }
                if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                    OS.gtk_label_set_xalign(n4, 0.0f);
                    OS.gtk_widget_set_halign(n4, 0);
                } else {
                    OS.gtk_misc_set_alignment(n4, 0.0f, 0.0f);
                }
                int n5 = this.gtk_box_new(0, false, 0);
                if (n5 == 0) {
                    this.error(2);
                }
                if (OS.SWT_PADDED_MENU_ITEMS) {
                    n3 = OS.gtk_image_new();
                    if (n3 == 0) {
                        this.error(2);
                    }
                    OS.gtk_image_set_pixel_size(n3, 16);
                    if (n5 != 0) {
                        OS.gtk_container_add(n5, n3);
                        OS.gtk_widget_show(n3);
                    }
                }
                if (n4 != 0 && n5 != 0) {
                    OS.gtk_box_pack_end(n5, n4, true, true, 0);
                    OS.gtk_widget_show(n4);
                }
                if (n5 != 0) {
                    OS.gtk_container_add(this.imItem, n5);
                    OS.gtk_widget_show(n5);
                }
            } else {
                this.imItem = OS.gtk_image_menu_item_new_with_label((byte[])objectArray);
                if (this.imItem == 0) {
                    this.error(2);
                }
            }
            OS.gtk_widget_show(this.imItem);
            OS.gtk_menu_shell_insert(this.handle, this.imItem, -1);
        }
        int n6 = OS.gtk_menu_new();
        OS.gtk_im_multicontext_append_menuitems(n, n6);
        OS.gtk_menu_item_set_submenu(this.imItem, n6);
    }

    @Override
    void createWidget(int n) {
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.parent.addMenu(this);
    }

    void fixMenus(Decorations decorations) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].fixMenus(decorations);
        }
        this.parent.removeMenu(this);
        decorations.addMenu(this);
        this.parent = decorations;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!this.gtk_widget_get_mapped(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n = this.gtk_widget_get_window(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n, nArray, nArray2);
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n2 = nArray[0] + gtkAllocation.x;
        int n3 = nArray2[0] + gtkAllocation.y;
        int n4 = gtkAllocation.width;
        int n5 = gtkAllocation.height;
        return new Rectangle(n2, n3, n4, n5);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.gtk_widget_get_sensitive(this.handle);
    }

    public MenuItem getItem(int n) {
        this.checkWidget();
        int n2 = OS.gtk_container_get_children(this.handle);
        if (n2 == 0) {
            this.error(8);
        }
        int n3 = OS.g_list_length(n2);
        if (this.imSeparator != 0) {
            --n3;
        }
        if (this.imItem != 0) {
            --n3;
        }
        if (0 > n || n >= n3) {
            this.error(6);
        }
        int n4 = OS.g_list_nth_data(n2, n);
        OS.g_list_free(n2);
        if (n4 == 0) {
            this.error(8);
        }
        return (MenuItem)this.display.getWidget(n4);
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.gtk_container_get_children(this.handle);
        if (n == 0) {
            return 0;
        }
        int n2 = OS.g_list_length(n);
        OS.g_list_free(n);
        if (this.imSeparator != 0) {
            --n2;
        }
        if (this.imItem != 0) {
            --n2;
        }
        return n2;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int n = OS.gtk_container_get_children(this.handle);
        if (n == 0) {
            return new MenuItem[0];
        }
        int n2 = n;
        int n3 = OS.g_list_length(n);
        if (this.imSeparator != 0) {
            --n3;
        }
        if (this.imItem != 0) {
            --n3;
        }
        MenuItem[] menuItemArray = new MenuItem[n3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = OS.g_list_data(n);
            MenuItem menuItem = (MenuItem)this.display.getWidget(n5);
            if (menuItem != null) {
                menuItemArray[n4++] = menuItem;
            }
            n = OS.g_list_next(n);
        }
        OS.g_list_free(n2);
        if (n4 != menuItemArray.length) {
            MenuItem[] menuItemArray2 = new MenuItem[n4];
            System.arraycopy(menuItemArray, 0, menuItemArray2, 0, n4);
            menuItemArray = menuItemArray2;
        }
        return menuItemArray;
    }

    @Override
    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                string = string + menuItemArray[i].getNameText() + ", ";
            }
            string = string + menuItemArray[n - 1].getNameText();
        }
        return string;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade == null) {
            return null;
        }
        return this.cascade.getParent();
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] menuArray;
        this.checkWidget();
        if ((this.style & 8) != 0 && (menuArray = this.display.popups) != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                if (menuArray[i] != this) continue;
                return true;
            }
        }
        return this.gtk_widget_get_mapped(this.handle);
    }

    @Override
    int gtk_hide(int n) {
        if ((this.style & 8) != 0 && this.display.activeShell != null) {
            this.display.activeShell = this.getShell();
            this.display.activeShell.ignoreFocusOut = false;
        }
        this.sendEvent(23);
        if (OS.ubuntu_menu_proxy_get() != 0) {
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (!menuItem.updateAcceleratorText(false)) continue;
            }
        }
        return 0;
    }

    @Override
    int gtk_show(int n) {
        if ((this.style & 8) != 0) {
            if (this.display.activeShell != null) {
                this.display.activeShell = this.getShell();
                this.display.activeShell.ignoreFocusOut = true;
            }
            return 0;
        }
        this.sendEvent(22);
        if (OS.ubuntu_menu_proxy_get() != 0) {
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (!menuItem.updateAcceleratorText(true)) continue;
            }
        }
        return 0;
    }

    @Override
    int gtk_show_help(int n, int n2) {
        if (this.sendHelpEvent(n2)) {
            OS.gtk_menu_shell_deactivate(this.handle);
            return 1;
        }
        return 0;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[45], 0, this.display.getClosure(45), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[24], 0, this.display.getClosure(24), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            if (menuItemArray[i] != menuItem) continue;
            return i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    int menuPositionProc(int n, int n2, int n3, int n4, int n5) {
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(n, gtkRequisition);
        int n6 = OS.gdk_screen_height();
        int n7 = this.y;
        if (n7 + gtkRequisition.height > n6) {
            n7 = Math.max(0, n7 - gtkRequisition.height);
        }
        int n8 = OS.gdk_screen_width();
        int n9 = this.x;
        if ((this.style & 0x4000000) != 0) {
            if (n9 - gtkRequisition.width >= 0) {
                n9 -= gtkRequisition.width;
            }
        } else if (n9 + gtkRequisition.width > n8) {
            n9 -= gtkRequisition.width;
        }
        if (n2 != 0) {
            OS.memmove(n2, new int[]{n9}, 4);
        }
        if (n3 != 0) {
            OS.memmove(n3, new int[]{n7}, 4);
        }
        if (n4 != 0) {
            OS.memmove(n4, new int[]{1}, 4);
        }
        return 0;
    }

    @Override
    void releaseChildren(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            if (menuItem == null || menuItem.isDisposed()) continue;
            menuItem.release(false);
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
        this.imHandle = 0;
        this.imSeparator = 0;
        this.imItem = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    void removeAccelerators(int n) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.removeAccelerators(n);
        }
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    @Override
    void reskinChildren(int n) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.reskin(n);
        }
        super.reskinChildren(n);
    }

    boolean sendHelpEvent(int n) {
        if (this.selectedItem != null && !this.selectedItem.isDisposed() && this.selectedItem.hooks(28)) {
            this.selectedItem.postEvent(28);
            return true;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return true;
        }
        return this.parent.sendHelpEvent(n);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        OS.gtk_widget_set_sensitive(this.handle, bl);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setLocation(new Point(n, n2));
    }

    void setLocationInPixels(int n, int n2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(point));
    }

    void setLocationInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocationInPixels(point.x, point.y);
    }

    public void setOrientation(int n) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this._setOrientation(n);
    }

    void _setOrientation(int n) {
        int n2 = 0x6000000;
        if ((n & n2) == 0 || (n & n2) == n2) {
            return;
        }
        this.style &= ~n2;
        this.style |= n & n2;
        this.setOrientation(false);
    }

    @Override
    void setOrientation(boolean bl) {
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0) {
                OS.gtk_widget_set_direction(this.handle, n);
            }
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                menuItemArray[i].setOrientation(bl);
            }
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

