/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.LayerGroup;
import org.openstreetmap.gui.jmapviewer.MapMarkerCircle;
import org.openstreetmap.gui.jmapviewer.Style;

public class AbstractLayer {
    private LayerGroup parent;
    private String name;
    private String description;
    private Style style;
    private Boolean visible;
    private Boolean visibleTexts = Boolean.TRUE;

    public AbstractLayer(String string) {
        this(string, (String)null);
    }

    public AbstractLayer(String string, String string2) {
        this(string, string2, MapMarkerCircle.getDefaultStyle());
    }

    public AbstractLayer(String string, Style style) {
        this(string, null, style);
    }

    public AbstractLayer(String string, String string2, Style style) {
        this(null, string, string2, style);
    }

    public AbstractLayer(LayerGroup layerGroup, String string) {
        this(layerGroup, string, MapMarkerCircle.getDefaultStyle());
    }

    public AbstractLayer(LayerGroup layerGroup, String string, Style style) {
        this(layerGroup, string, null, style);
    }

    public AbstractLayer(LayerGroup layerGroup, String string, String string2, Style style) {
        this.setParent(layerGroup);
        this.setName(string);
        this.setDescription(string2);
        this.setStyle(style);
        this.setVisible(Boolean.TRUE);
        if (layerGroup != null) {
            layerGroup.add(this);
        }
    }

    public LayerGroup getParent() {
        return this.parent;
    }

    public void setParent(LayerGroup layerGroup) {
        this.parent = layerGroup;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public void setVisible(Boolean bl) {
        this.visible = bl;
    }

    public static <E> List<E> add(List<E> list, E e) {
        if (e != null) {
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(e)) {
                list.add(e);
            }
        }
        return list;
    }

    public Boolean isVisibleTexts() {
        return this.visibleTexts;
    }

    public void setVisibleTexts(Boolean bl) {
        this.visibleTexts = bl;
    }

    public String toString() {
        return this.name;
    }
}

