/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.datatransfer.OsmTransferHandler;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class MapView
extends NavigatableComponent
implements PropertyChangeListener,
Preferences.PreferenceChangedListener,
LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    public boolean viewportFollowing;
    private final MainLayerManager layerManager;
    public transient PlayHeadMarker playHeadMarker;
    public MouseEvent lastMEvent = new MouseEvent(this, 0, 0L, 0, 0, 0, 0, false);
    private final transient Set<MapViewPaintable> temporaryLayers = new LinkedHashSet<MapViewPaintable>();
    private transient BufferedImage nonChangedLayersBuffer;
    private transient BufferedImage offscreenBuffer;
    private final transient List<Layer> nonChangedLayers = new ArrayList<Layer>();
    private int lastViewID;
    private final AtomicBoolean paintPreferencesChanged = new AtomicBoolean(true);
    private Rectangle lastClipBounds = new Rectangle();
    private transient MapMover mapMover;
    private final LayerInvalidatedListener invalidatedListener = new LayerInvalidatedListener();
    private final HashMap<Layer, MapViewPaintable.LayerPainter> registeredLayers = new HashMap();
    private Dimension oldSize;
    private Point oldLoc;
    private boolean virtualNodesEnabled;
    private final transient SelectionChangedListener repaintSelectionChangedListener = collection -> this.repaint();
    private final transient CopyOnWriteArrayList<RepaintListener> repaintListeners = new CopyOnWriteArrayList();

    public MapView(MainLayerManager mainLayerManager, final JPanel jPanel, ViewportData viewportData) {
        this.layerManager = mainLayerManager;
        this.initialViewport = viewportData;
        mainLayerManager.addLayerChangeListener(this, true);
        mainLayerManager.addActiveLayerChangeListener(this);
        Main.pref.addPreferenceChangeListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MapView.this.removeComponentListener(this);
                MapView.this.mapMover = new MapMover(MapView.this, jPanel);
            }
        });
        DataSet.addSelectionListener(this.repaintSelectionChangedListener);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                MapView.this.lastMEvent = mouseEvent;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MapView.this.requestFocus();
            }
        });
        this.setFocusTraversalKeysEnabled(!Shortcut.findShortcut(9, 0).isPresent());
        for (JComponent jComponent : MapView.getMapNavigationComponents(this)) {
            this.add(jComponent);
        }
        this.setTransferHandler(new OsmTransferHandler());
    }

    public static List<? extends JComponent> getMapNavigationComponents(MapView mapView) {
        MapSlider mapSlider = new MapSlider(mapView);
        Dimension dimension = mapSlider.getPreferredSize();
        mapSlider.setSize(dimension);
        mapSlider.setLocation(3, 0);
        mapSlider.setFocusTraversalKeysEnabled(!Shortcut.findShortcut(9, 0).isPresent());
        MapScaler mapScaler = new MapScaler(mapView);
        mapScaler.setPreferredLineLength(dimension.width - 10);
        mapScaler.setSize(mapScaler.getPreferredSize());
        mapScaler.setLocation(3, dimension.height);
        return Arrays.asList(mapSlider, mapScaler);
    }

    public void rememberLastPositionOnScreen() {
        this.oldSize = this.getSize();
        this.oldLoc = this.getLocationOnScreen();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
        try {
            Layer layer = layerAddEvent.getAddedLayer();
            this.registeredLayers.put(layer, new WarningLayerPainter(layer));
            MapViewPaintable.LayerPainter layerPainter = layer.attachToMapView(new MapViewPaintable.MapViewEvent(this, false));
            if (!this.registeredLayers.containsKey(layer)) {
                Main.warn("Layer was removed during attachToMapView()");
            } else {
                this.registeredLayers.put(layer, layerPainter);
                ProjectionBounds projectionBounds = layer.getViewProjectionBounds();
                if (projectionBounds != null) {
                    this.scheduleZoomTo(new ViewportData(projectionBounds));
                }
                layer.addPropertyChangeListener(this);
                Main.addProjectionChangeListener(layer);
                this.invalidatedListener.addTo(layer);
                AudioPlayer.reset();
                this.repaint();
            }
        }
        catch (RuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("layer", layerAddEvent.getAddedLayer());
        }
    }

    public boolean isActiveLayerDrawable() {
        return this.layerManager.getEditLayer() != null;
    }

    public boolean isActiveLayerVisible() {
        OsmDataLayer osmDataLayer = this.layerManager.getEditLayer();
        return osmDataLayer != null && osmDataLayer.isVisible();
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        Layer layer = layerRemoveEvent.getRemovedLayer();
        MapViewPaintable.LayerPainter layerPainter = this.registeredLayers.remove(layer);
        if (layerPainter == null) {
            Main.error("The painter for layer " + layer + " was not registered.");
            return;
        }
        layerPainter.detachFromMapView(new MapViewPaintable.MapViewEvent(this, false));
        Main.removeProjectionChangeListener(layer);
        layer.removePropertyChangeListener(this);
        this.invalidatedListener.removeFrom(layer);
        layer.destroy();
        AudioPlayer.reset();
        this.repaint();
    }

    public void setVirtualNodesEnabled(boolean bl) {
        if (this.virtualNodesEnabled != bl) {
            this.virtualNodesEnabled = bl;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int n) {
        this.layerManager.moveLayer(layer, n);
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
        AudioPlayer.reset();
        this.repaint();
    }

    private void paintLayer(Layer layer, Graphics2D graphics2D, Bounds bounds) {
        try {
            MapViewPaintable.LayerPainter layerPainter = this.registeredLayers.get(layer);
            if (layerPainter == null) {
                throw new IllegalArgumentException("Cannot paint layer, it is not registered.");
            }
            MapViewState.MapViewRectangle mapViewRectangle = this.getState().getViewArea(graphics2D.getClipBounds());
            MapViewGraphics mapViewGraphics = new MapViewGraphics(this, graphics2D, mapViewRectangle);
            if (layer.getOpacity() < 1.0) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, (float)layer.getOpacity()));
            }
            layerPainter.paint(mapViewGraphics);
            graphics2D.setPaintMode();
        }
        catch (RuntimeException runtimeException) {
            BugReport.intercept(runtimeException).put("layer", layer).put("bounds", bounds).warn();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        Graphics2D i;
        boolean bl;
        try {
            if (!this.prepareToDraw()) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            BugReport.intercept(runtimeException).put("center", this::getCenter).warn();
            return;
        }
        List<Layer> list = this.layerManager.getVisibleLayersInZOrder();
        int n2 = 0;
        Set<MapViewPaintable> set = this.invalidatedListener.collectInvalidatedLayers();
        for (Layer object2 : list) {
            if (object2.isChanged() || set.contains(object2)) break;
            ++n2;
        }
        boolean bl2 = bl = !this.paintPreferencesChanged.getAndSet(false) && this.nonChangedLayers.size() <= n2 && this.lastViewID == this.getViewID() && this.lastClipBounds.contains(graphics.getClipBounds()) && this.nonChangedLayers.equals(list.subList(0, this.nonChangedLayers.size()));
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setClip(graphics.getClip());
        Bounds bounds = this.getLatLonBounds(graphics.getClipBounds());
        if (!bl || this.nonChangedLayersBuffer == null) {
            if (null == this.nonChangedLayersBuffer || this.nonChangedLayersBuffer.getWidth() != this.getWidth() || this.nonChangedLayersBuffer.getHeight() != this.getHeight()) {
                this.nonChangedLayersBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
            }
            i = this.nonChangedLayersBuffer.createGraphics();
            i.setClip(graphics.getClip());
            i.setColor(PaintColors.getBackgroundColor());
            i.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (n = 0; n < n2; ++n) {
                this.paintLayer(list.get(n), i, bounds);
            }
        } else if (this.nonChangedLayers.size() != n2) {
            i = this.nonChangedLayersBuffer.createGraphics();
            i.setClip(graphics.getClip());
            for (n = this.nonChangedLayers.size(); n < n2; ++n) {
                this.paintLayer(list.get(n), i, bounds);
            }
        }
        this.nonChangedLayers.clear();
        this.nonChangedLayers.addAll(list.subList(0, n2));
        this.lastViewID = this.getViewID();
        this.lastClipBounds = graphics.getClipBounds();
        graphics2D.drawImage((Image)this.nonChangedLayersBuffer, 0, 0, null);
        for (int runtimeException = n2; runtimeException < list.size(); ++runtimeException) {
            this.paintLayer(list.get(runtimeException), graphics2D, bounds);
        }
        try {
            this.drawTemporaryLayers(graphics2D, bounds);
        }
        catch (RuntimeException runtimeException) {
            BugReport.intercept(runtimeException).put("temporaryLayers", this.temporaryLayers).warn();
        }
        try {
            this.drawWorldBorders(graphics2D);
        }
        catch (RuntimeException classCastException) {
            BugReport.intercept(classCastException).put("bounds", () -> this.getProjection().getWorldBoundsLatLon()).warn();
        }
        if (Main.isDisplayingMapView() && Main.map.filterDialog != null) {
            Main.map.filterDialog.drawOSDText(graphics2D);
        }
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        try {
            graphics.drawImage(this.offscreenBuffer, 0, 0, null);
        }
        catch (ClassCastException classCastException) {
            Main.error(classCastException);
        }
        super.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTemporaryLayers(Graphics2D graphics2D, Bounds bounds) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            for (MapViewPaintable mapViewPaintable : this.temporaryLayers) {
                try {
                    mapViewPaintable.paint(graphics2D, this, bounds);
                }
                catch (RuntimeException runtimeException) {
                    throw BugReport.intercept(runtimeException).put("mvp", mapViewPaintable);
                }
            }
        }
    }

    private void drawWorldBorders(Graphics2D graphics2D) {
        graphics2D.setColor(Color.WHITE);
        Bounds bounds = this.getProjection().getWorldBoundsLatLon();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Area area = this.getState().getArea(bounds);
        Area area2 = new Area(new Rectangle(-1, -1, n + 2, n2 + 2));
        area.intersect(area2);
        graphics2D.draw(area);
    }

    public boolean prepareToDraw() {
        this.updateLocationState();
        if (this.initialViewport != null) {
            this.zoomTo(this.initialViewport);
            this.initialViewport = null;
        }
        if (this.getCenter() == null) {
            return false;
        }
        if (this.oldLoc != null && this.oldSize != null) {
            Point point = this.getLocationOnScreen();
            EastNorth eastNorth = new EastNorth(this.getCenter().getX() + ((double)(point.x - this.oldLoc.x) - (double)(this.oldSize.width - this.getWidth()) / 2.0) * this.getScale(), this.getCenter().getY() + ((double)(this.oldLoc.y - point.y) + (double)(this.oldSize.height - this.getHeight()) / 2.0) * this.getScale());
            this.oldLoc = null;
            this.oldSize = null;
            this.zoomTo(eastNorth);
        }
        return true;
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
        if (Main.map != null) {
            for (AbstractButton abstractButton : Main.map.allMapModeButtons) {
                MapMode mapMode = (MapMode)abstractButton.getAction();
                boolean bl = mapMode.layerIsSupported(this.layerManager.getActiveLayer());
                if (bl) {
                    Main.registerActionShortcut(mapMode, mapMode.getShortcut());
                } else {
                    Main.unregisterShortcut(mapMode.getShortcut());
                }
                abstractButton.setEnabled(bl);
            }
        }
        AudioPlayer.reset();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTemporaryLayer(MapViewPaintable mapViewPaintable) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            boolean bl = this.temporaryLayers.add(mapViewPaintable);
            if (bl) {
                this.invalidatedListener.addTo(mapViewPaintable);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTemporaryLayer(MapViewPaintable mapViewPaintable) {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            boolean bl = this.temporaryLayers.remove(mapViewPaintable);
            if (bl) {
                this.invalidatedListener.removeFrom(mapViewPaintable);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MapViewPaintable> getTemporaryLayers() {
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<MapViewPaintable>(this.temporaryLayers));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Layer layer;
        if (propertyChangeEvent.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if ((propertyChangeEvent.getPropertyName().equals(Layer.OPACITY_PROP) || propertyChangeEvent.getPropertyName().equals(Layer.FILTER_STATE_PROP)) && (layer = (Layer)propertyChangeEvent.getSource()).isVisible()) {
            this.invalidatedListener.invalidate(layer);
        }
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        this.paintPreferencesChanged.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.layerManager.removeLayerChangeListener(this, true);
        this.layerManager.removeActiveLayerChangeListener(this);
        Main.pref.removePreferenceChangeListener(this);
        DataSet.removeSelectionListener(this.repaintSelectionChangedListener);
        MultipolygonCache.getInstance().clear(this);
        if (this.mapMover != null) {
            this.mapMover.destroy();
        }
        this.nonChangedLayers.clear();
        Set<MapViewPaintable> set = this.temporaryLayers;
        synchronized (set) {
            this.temporaryLayers.clear();
        }
        this.nonChangedLayersBuffer = null;
        this.offscreenBuffer = null;
    }

    public String getLayerInformationForSourceTag() {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (!this.layerManager.getLayersOfType(GpxLayer.class).isEmpty()) {
            treeSet.add("survey");
        }
        for (GeoImageLayer layer : this.layerManager.getLayersOfType(GeoImageLayer.class)) {
            if (!layer.isVisible()) continue;
            treeSet.add(layer.getName());
        }
        for (ImageryLayer imageryLayer : this.layerManager.getLayersOfType(ImageryLayer.class)) {
            if (!imageryLayer.isVisible()) continue;
            treeSet.add(ImageryInfo.ImageryType.BING.equals((Object)imageryLayer.getInfo().getImageryType()) ? "Bing" : imageryLayer.getName());
        }
        return Utils.join("; ", treeSet);
    }

    public void addRepaintListener(RepaintListener repaintListener) {
        this.repaintListeners.add(repaintListener);
    }

    public void removeRepaintListener(RepaintListener repaintListener) {
        this.repaintListeners.remove(repaintListener);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.repaintListeners != null) {
            for (RepaintListener repaintListener : this.repaintListeners) {
                repaintListener.repaint(l, n, n2, n3, n4);
            }
        }
        super.repaint(l, n, n2, n3, n4);
    }

    @Override
    public void repaint() {
        if (Main.isTraceEnabled()) {
            this.invalidatedListener.traceRandomRepaint();
        }
        super.repaint();
    }

    public final MainLayerManager getLayerManager() {
        return this.layerManager;
    }

    public void scheduleZoomTo(ViewportData viewportData) {
        this.initialViewport = viewportData;
    }

    @FunctionalInterface
    public static interface RepaintListener {
        public void repaint(long var1, int var3, int var4, int var5, int var6);
    }

    private static class WarningLayerPainter
    implements MapViewPaintable.LayerPainter {
        boolean warningPrinted;
        private final Layer layer;

        WarningLayerPainter(Layer layer) {
            this.layer = layer;
        }

        @Override
        public void paint(MapViewGraphics mapViewGraphics) {
            if (!this.warningPrinted) {
                Main.debug("A layer triggered a repaint while being added: " + this.layer);
                this.warningPrinted = true;
            }
        }

        @Override
        public void detachFromMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
        }
    }

    private class LayerInvalidatedListener
    implements MapViewPaintable.PaintableInvalidationListener {
        private boolean ignoreRepaint;
        private final Set<MapViewPaintable> invalidatedLayers = Collections.newSetFromMap(new IdentityHashMap());

        private LayerInvalidatedListener() {
        }

        @Override
        public void paintableInvalidated(MapViewPaintable.PaintableInvalidationEvent paintableInvalidationEvent) {
            this.invalidate(paintableInvalidationEvent.getLayer());
        }

        public synchronized void invalidate(MapViewPaintable mapViewPaintable) {
            this.ignoreRepaint = true;
            this.invalidatedLayers.add(mapViewPaintable);
            MapView.this.repaint();
        }

        public synchronized void addTo(MapViewPaintable mapViewPaintable) {
            if (mapViewPaintable instanceof AbstractMapViewPaintable) {
                ((AbstractMapViewPaintable)mapViewPaintable).addInvalidationListener(this);
            }
        }

        public synchronized void removeFrom(MapViewPaintable mapViewPaintable) {
            if (mapViewPaintable instanceof AbstractMapViewPaintable) {
                ((AbstractMapViewPaintable)mapViewPaintable).removeInvalidationListener(this);
            }
            this.invalidatedLayers.remove(mapViewPaintable);
        }

        protected synchronized void traceRandomRepaint() {
            if (!this.ignoreRepaint) {
                System.err.println("Repaint:");
                Thread.dumpStack();
            }
            this.ignoreRepaint = false;
        }

        protected synchronized Set<MapViewPaintable> collectInvalidatedLayers() {
            Set<MapViewPaintable> set = Collections.newSetFromMap(new IdentityHashMap());
            set.addAll(this.invalidatedLayers);
            this.invalidatedLayers.clear();
            return set;
        }
    }
}

