/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class TruffleMap<K, V>
extends AbstractMap<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final TruffleObject obj;

    private TruffleMap(Class<K> keyType, Class<V> valueType, TruffleObject obj) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.obj = obj;
    }

    static <K, V> Map<K, V> create(Class<K> keyType, Class<V> valueType, TruffleObject foreignObject) {
        return new TruffleMap<K, V>(keyType, valueType, foreignObject);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try {
            Object props = ToJavaNode.message(Message.KEYS, this.obj, new Object[0]);
            if (Boolean.TRUE.equals(ToJavaNode.message(Message.HAS_SIZE, props, new Object[0]))) {
                Number size = (Number)ToJavaNode.message(Message.GET_SIZE, props, new Object[0]);
                LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
                for (int i = 0; i < size.intValue(); ++i) {
                    Object key = ToJavaNode.message(Message.READ, props, i);
                    entries.add(new TruffleEntry(this.keyType.cast(key)));
                }
                return entries;
            }
            return Collections.emptySet();
        }
        catch (InteropException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public V get(Object key) {
        this.keyType.cast(key);
        try {
            return this.valueType.cast(ToJavaNode.message(Message.READ, this.obj, key));
        }
        catch (InteropException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public V put(K key, V value) {
        this.keyType.cast(key);
        this.valueType.cast(value);
        try {
            return this.valueType.cast(ToJavaNode.message(Message.WRITE, this.obj, key, value));
        }
        catch (InteropException e) {
            throw new IllegalStateException(e);
        }
    }

    private final class TruffleEntry
    implements Map.Entry<K, V> {
        private final K key;

        TruffleEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            try {
                return TruffleMap.this.valueType.cast(ToJavaNode.message(Message.READ, TruffleMap.this.obj, this.key));
            }
            catch (InteropException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public V setValue(V value) {
            try {
                Object prev = this.getValue();
                ToJavaNode.message(Message.WRITE, TruffleMap.this.obj, this.key, value);
                return prev;
            }
            catch (InteropException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

