/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import org.jruby.Ruby;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.ForParseNode;
import org.jruby.truffle.parser.ast.IterParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.PostExeParseNode;
import org.jruby.truffle.parser.ast.PreExeParseNode;
import org.jruby.truffle.parser.ast.StarParseNode;
import org.jruby.truffle.parser.ast.UnnamedRestArgParseNode;
import org.jruby.util.TypeConverter;

public class Signature {
    public static final Signature NO_ARGUMENTS = new Signature(0, 0, 0, Rest.NONE, 0, 0, false);
    public static final Signature ONE_ARGUMENT = new Signature(1, 0, 0, Rest.NONE, 0, 0, false);
    public static final Signature TWO_ARGUMENTS = new Signature(2, 0, 0, Rest.NONE, 0, 0, false);
    public static final Signature THREE_ARGUMENTS = new Signature(3, 0, 0, Rest.NONE, 0, 0, false);
    public static final Signature OPTIONAL = new Signature(0, 0, 0, Rest.NORM, 0, 0, false);
    public static final Signature ONE_REQUIRED = new Signature(1, 0, 0, Rest.NORM, 0, 0, false);
    public static final Signature TWO_REQUIRED = new Signature(2, 0, 0, Rest.NORM, 0, 0, false);
    public static final Signature THREE_REQUIRED = new Signature(3, 0, 0, Rest.NORM, 0, 0, false);
    private final short pre;
    private final short opt;
    private final Rest rest;
    private final short post;
    private final short kwargs;
    private final short requiredKwargs;
    private final Arity arity;
    private final boolean restKwargs;
    private static final int MAX_ENCODED_ARGS_EXPONENT = 8;
    private static final int MAX_ENCODED_ARGS_MASK = 255;
    private static final int ENCODE_RESTKWARGS_SHIFT = 0;
    private static final int ENCODE_REST_SHIFT = 1;
    private static final int ENCODE_REQKWARGS_SHIFT = 9;
    private static final int ENCODE_KWARGS_SHIFT = 17;
    private static final int ENCODE_POST_SHIFT = 25;
    private static final int ENCODE_OPT_SHIFT = 33;
    private static final int ENCODE_PRE_SHIFT = 41;

    public Signature(int pre, int opt, int post, Rest rest, int kwargs, int requiredKwargs, boolean restKwargs) {
        this.pre = (short)pre;
        this.opt = (short)opt;
        this.post = (short)post;
        this.rest = rest;
        this.kwargs = (short)kwargs;
        this.requiredKwargs = (short)requiredKwargs;
        this.restKwargs = restKwargs;
        this.arity = rest != Rest.NONE || opt != 0 ? Arity.createArity((int)(-(this.required() + 1))) : Arity.fixed((int)(this.required() + this.getRequiredKeywordForArityCount()));
    }

    public int getRequiredKeywordForArityCount() {
        return this.requiredKwargs > 0 ? 1 : 0;
    }

    public boolean restKwargs() {
        return this.restKwargs;
    }

    public int pre() {
        return this.pre;
    }

    public int opt() {
        return this.opt;
    }

    public Rest rest() {
        return this.rest;
    }

    public int post() {
        return this.post;
    }

    public boolean hasKwargs() {
        return this.kwargs > 0 || this.restKwargs;
    }

    public boolean hasRest() {
        return this.rest != Rest.NONE;
    }

    public boolean isFixed() {
        return this.arityValue() >= 0;
    }

    public int required() {
        return this.pre + this.post;
    }

    public Arity arity() {
        return this.arity;
    }

    public int arityValue() {
        boolean hasOptionalKeywords;
        int oneForKeywords = this.requiredKwargs > 0 ? 1 : 0;
        int fixedValue = this.pre() + this.post() + oneForKeywords;
        boolean bl = hasOptionalKeywords = this.kwargs - this.requiredKwargs > 0;
        if (this.opt() > 0 || this.rest() != Rest.NONE || (hasOptionalKeywords || this.restKwargs()) && oneForKeywords == 0) {
            return -1 * (fixedValue + 1);
        }
        return fixedValue;
    }

    public static Signature from(Arity arity) {
        switch (arity.required()) {
            case 0: {
                return arity.isFixed() ? NO_ARGUMENTS : OPTIONAL;
            }
            case 1: {
                return arity.isFixed() ? ONE_ARGUMENT : ONE_REQUIRED;
            }
            case 2: {
                return arity.isFixed() ? TWO_ARGUMENTS : TWO_REQUIRED;
            }
            case 3: {
                return arity.isFixed() ? THREE_ARGUMENTS : THREE_REQUIRED;
            }
        }
        throw new UnsupportedOperationException("We do not know enough about the arity to convert it to a signature");
    }

    public static Signature from(int pre, int opt, int post, int kwargs, int requiredKwargs, Rest rest, boolean restKwargs) {
        if (opt == 0 && post == 0 && kwargs == 0 && !restKwargs) {
            switch (pre) {
                case 0: {
                    switch (rest) {
                        case NONE: {
                            return NO_ARGUMENTS;
                        }
                        case NORM: {
                            return OPTIONAL;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (rest) {
                        case NONE: {
                            return ONE_ARGUMENT;
                        }
                        case NORM: {
                            return ONE_REQUIRED;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (rest) {
                        case NONE: {
                            return TWO_ARGUMENTS;
                        }
                        case NORM: {
                            return TWO_REQUIRED;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (rest) {
                        case NONE: {
                            return THREE_ARGUMENTS;
                        }
                        case NORM: {
                            return THREE_REQUIRED;
                        }
                    }
                }
            }
        }
        return new Signature(pre, opt, post, rest, kwargs, requiredKwargs, restKwargs);
    }

    public static Signature from(ArgsParseNode args) {
        ArgumentParseNode restArg = args.getRestArgNode();
        Rest rest = restArg != null ? Signature.restFromArg(restArg) : Rest.NONE;
        return Signature.from(args.getPreCount(), args.getOptionalArgsCount(), args.getPostCount(), args.getKeywordCount(), args.getRequiredKeywordCount(), rest, args.hasKeyRest());
    }

    public static Signature from(IterParseNode iter) {
        if (iter instanceof ForParseNode) {
            return Signature.from((ForParseNode)iter);
        }
        if (iter instanceof PreExeParseNode) {
            return Signature.from((PreExeParseNode)iter);
        }
        if (iter instanceof PostExeParseNode) {
            return Signature.from((PostExeParseNode)iter);
        }
        return Signature.from((ArgsParseNode)iter.getVarNode());
    }

    private static Rest restFromArg(ParseNode restArg) {
        UnnamedRestArgParseNode anonRest;
        Rest rest = restArg instanceof UnnamedRestArgParseNode ? ((anonRest = (UnnamedRestArgParseNode)restArg).isStar() ? Rest.STAR : Rest.ANON) : (restArg instanceof StarParseNode ? Rest.STAR : Rest.NORM);
        return rest;
    }

    public static Signature from(ForParseNode iter) {
        ParseNode var = iter.getVarNode();
        if (var instanceof MultipleAsgnParseNode) {
            MultipleAsgnParseNode masgn = (MultipleAsgnParseNode)var;
            Rest rest = Rest.NONE;
            if (masgn.getRest() != null) {
                ParseNode restArg = masgn.getRest();
                rest = Signature.restFromArg(restArg);
            }
            return Signature.from(masgn.getPreCount(), 0, masgn.getPostCount(), 0, 0, rest, false);
        }
        return ONE_ARGUMENT;
    }

    public static Signature from(PreExeParseNode iter) {
        return NO_ARGUMENTS;
    }

    public static Signature from(PostExeParseNode iter) {
        return NO_ARGUMENTS;
    }

    public long encode() {
        return (long)this.pre << 41 | (long)this.opt << 33 | (long)this.post << 25 | (long)this.kwargs << 17 | (long)this.requiredKwargs << 9 | (long)(this.rest.ordinal() << 1) | (long)((this.restKwargs ? 1 : 0) << 0);
    }

    public static Signature decode(long l) {
        return Signature.from((int)(l >> 41) & 0xFF, (int)(l >> 33) & 0xFF, (int)(l >> 25) & 0xFF, (int)(l >> 17) & 0xFF, (int)(l >> 9) & 0xFF, Rest.fromOrdinal((int)(l >> 1 & 0xFFL)), ((int)(l >> 0) & 1) == 1);
    }

    public String toString() {
        return "signature(pre=" + this.pre + ",opt=" + this.opt + ",post=" + this.post + ",rest=" + (Object)((Object)this.rest) + ",kwargs=" + this.kwargs + ",kwreq=" + this.requiredKwargs + ",kwrest=" + this.restKwargs + ")";
    }

    public void checkArity(Ruby runtime, IRubyObject[] args) {
        if (args.length < this.required()) {
            throw runtime.newArgumentError("wrong number of arguments (" + args.length + " for " + this.required() + ")");
        }
        if ((this.rest == Rest.NONE || this.rest == Rest.ANON) && args.length > this.required() + this.opt()) {
            if (this.hasKwargs() && !TypeConverter.checkHashType((Ruby)runtime, (IRubyObject)args[args.length - 1]).isNil()) {
                if (args.length - 1 > this.required() + this.opt()) {
                    throw runtime.newArgumentError("wrong number of arguments (" + args.length + " for " + (this.required() + this.opt) + ")");
                }
            } else {
                throw runtime.newArgumentError("wrong number of arguments (" + args.length + " for " + (this.required() + this.opt) + ")");
            }
        }
    }

    public static enum Rest {
        NONE,
        NORM,
        ANON,
        STAR;

        private static final Rest[] VALUES;

        public static Rest fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                throw new RuntimeException("invalid Rest: " + ordinal);
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = Rest.values();
        }
    }
}

