/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.ControlReader;
import writer2latex.office.FormReader;

public class FormsReader {
    private Element formsElement;
    private Hashtable<String, FormReader> forms = new Hashtable();
    private Hashtable<String, ControlReader> controls = new Hashtable();

    public void read(Element formsElement) {
        this.formsElement = formsElement;
        for (Node child = formsElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals("form:form")) continue;
            FormReader form = new FormReader((Element)child, this);
            this.forms.put(form.getName(), form);
        }
    }

    public String getAttribute(String sName) {
        return this.formsElement.hasAttribute(sName) ? this.formsElement.getAttribute(sName) : null;
    }

    public Iterator<FormReader> getFormsIterator() {
        return this.forms.values().iterator();
    }

    public FormReader getForm(String sName) {
        return this.forms.get(sName);
    }

    public Iterator<ControlReader> getControlsIterator() {
        return this.controls.values().iterator();
    }

    public ControlReader getControl(String sId) {
        return this.controls.get(sId);
    }

    protected void addControl(ControlReader control) {
        this.controls.put(control.getId(), control);
    }
}

