/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.response;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;

public class ResponseStringHttpPanelViewModel
extends AbstractHttpStringHttpPanelViewModel {
    private static final Logger logger = Logger.getLogger(ResponseStringHttpPanelViewModel.class);

    @Override
    public String getData() {
        if (this.httpMessage == null || this.httpMessage.getResponseHeader().isEmpty()) {
            return "";
        }
        return this.httpMessage.getResponseHeader().toString().replaceAll("\r\n", "\n") + this.getBody();
    }

    private String getBody() {
        if ("gzip".equals(this.httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.httpMessage.getResponseBody().getBytes());
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                InputStreamReader inputStreamReader = new InputStreamReader(gZIPInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuilder stringBuilder = new StringBuilder();
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
                bufferedReader.close();
                inputStreamReader.close();
                gZIPInputStream.close();
                byteArrayInputStream.close();
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        return this.httpMessage.getResponseBody().toString();
    }

    @Override
    public void setData(String string) {
        String[] stringArray = string.split("\n\n");
        String string2 = stringArray[0].replaceAll("(?<!\r)\n", "\r\n");
        try {
            this.httpMessage.setResponseHeader(string2);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            logger.warn((Object)("Could not Save Header: " + string2), (Throwable)httpMalformedHeaderException);
        }
        if (stringArray.length > 1) {
            String string3 = string.substring(stringArray[0].length() + 2);
            if ("gzip".equals(this.httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)gZIPOutputStream, "UTF-8"));
                    bufferedWriter.write(string3);
                    bufferedWriter.close();
                    gZIPOutputStream.close();
                    byteArrayOutputStream.close();
                    this.httpMessage.getResponseBody().setBody(byteArrayOutputStream.toByteArray());
                    HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
            } else {
                this.httpMessage.setResponseBody(string3);
            }
        } else {
            this.httpMessage.setResponseBody("");
        }
        HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
    }
}

