/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.beans;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.beans.ContainerFactory;
import com.sun.star.comp.beans.LocalOfficeWindow;
import com.sun.star.comp.beans.NativeService;
import com.sun.star.comp.beans.OfficeConnection;
import com.sun.star.comp.beans.OfficeWindow;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.UnoUrl;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class LocalOfficeConnection
implements OfficeConnection {
    public static final String OFFICE_APP_NAME = "soffice";
    public static final String OFFICE_LIB_NAME = "officebean";
    public static final String OFFICE_ID_SUFFIX = "_Office";
    private Process mProcess;
    private XComponentContext mContext;
    private XBridge mBridge;
    private String mURL;
    private String mConnType;
    private String mPipe;
    private String mPort;
    private String mProtocol;
    private String mInitialObject;
    private final List<XEventListener> mComponents = new ArrayList<XEventListener>();
    private static final AtomicLong m_nBridgeCounter = new AtomicLong(0L);

    public LocalOfficeConnection() {
        try {
            this.setUnoUrl("uno:pipe,name=" + LocalOfficeConnection.getPipeName() + ";urp;StarOffice.ServiceManager");
        }
        catch (MalformedURLException e) {
            throw new com.sun.star.uno.RuntimeException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new com.sun.star.uno.RuntimeException((Throwable)e);
        }
    }

    protected LocalOfficeConnection(XComponentContext xContext) {
        this.mContext = xContext;
    }

    public void setUnoUrl(String url) throws MalformedURLException {
        this.mURL = null;
        String prefix = "uno:localoffice";
        if (url.startsWith(prefix)) {
            this.parseUnoUrlWithOfficePath(url, prefix);
        } else {
            try {
                UnoUrl aURL = UnoUrl.parseUnoUrl((String)url);
                this.mConnType = aURL.getConnection();
                this.mPipe = (String)aURL.getConnectionParameters().get("pipe");
                this.mPort = (String)aURL.getConnectionParameters().get("port");
                this.mProtocol = aURL.getProtocol();
                this.mInitialObject = aURL.getRootOid();
            }
            catch (IllegalArgumentException ex1) {
                MalformedURLException ex2 = new MalformedURLException("Invalid UNO connection URL.");
                ex2.initCause(ex1);
                throw ex2;
            }
        }
        this.mURL = url;
    }

    @Deprecated
    public void setContainerFactory(ContainerFactory containerFactory) {
    }

    public synchronized XComponentContext getComponentContext() {
        if (this.mContext == null) {
            this.mContext = this.connect();
        }
        return this.mContext;
    }

    @Deprecated
    public OfficeWindow createOfficeWindow(Container container) {
        return new LocalOfficeWindow(this);
    }

    public void dispose() {
        Iterator<XEventListener> itr = this.mComponents.iterator();
        while (itr.hasNext()) {
            try {
                itr.next().disposing(null);
            }
            catch (RuntimeException runtimeException) {}
        }
        this.mComponents.clear();
        if (this.mBridge != null) {
            XComponent comp = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.mBridge);
            if (comp != null) {
                comp.dispose();
            } else {
                System.err.println("LocalOfficeConnection: could not dispose bridge!");
            }
            this.mBridge = null;
        }
        this.mContext = null;
    }

    public void addEventListener(XEventListener listener) {
        this.mComponents.add(listener);
    }

    public void removeEventListener(XEventListener listener) {
        this.mComponents.remove(listener);
    }

    private XComponentContext connect() {
        try {
            XComponentContext xLocalContext = Bootstrap.createInitialComponentContext(null);
            xLocalContext.getServiceManager();
            Object aInitialObject = null;
            try {
                aInitialObject = this.resolve(xLocalContext, this.mURL);
            }
            catch (NoConnectException e) {
                OfficeService aSOffice = new OfficeService();
                aSOffice.startupService();
                long nGiveUpTimeMillis = System.currentTimeMillis() + 1000L * (long)aSOffice.getStartupTime();
                while (aInitialObject == null) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        aInitialObject = this.resolve(xLocalContext, this.mURL);
                    }
                    catch (NoConnectException aEx) {
                        if (System.currentTimeMillis() <= nGiveUpTimeMillis) continue;
                        throw aEx;
                    }
                }
            }
            if (null != aInitialObject) {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)aInitialObject);
                Object xContext = xPropertySet.getPropertyValue("DefaultContext");
                XComponentContext xComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)xContext);
                return xComponentContext;
            }
        }
        catch (NoConnectException e) {
            System.out.println("Couldn't connect to remote server");
            System.out.println(e.getMessage());
        }
        catch (ConnectionSetupException e) {
            System.out.println("Couldn't access necessary local resource to establish the interprocess connection");
            System.out.println(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println("uno-url is syntactical illegal ( " + this.mURL + " )");
            System.out.println(e.getMessage());
        }
        catch (com.sun.star.uno.RuntimeException e) {
            System.out.println("--- RuntimeException:");
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.out.println("--- end.");
            throw e;
        }
        catch (Exception e) {
            System.out.println("java.lang.Exception: ");
            System.out.println(e);
            e.printStackTrace();
            System.out.println("--- end.");
            throw new com.sun.star.uno.RuntimeException((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resolve(XComponentContext xLocalContext, String dcp) throws NoConnectException, ConnectionSetupException, IllegalArgumentException {
        String conDcp = null;
        String protDcp = null;
        String rootOid = null;
        if (dcp.indexOf(59) == -1) {
            conDcp = dcp;
            protDcp = "iiop";
            rootOid = "classic_uno";
        } else {
            int index = dcp.indexOf(58);
            dcp = dcp.substring(index + 1).trim();
            index = dcp.indexOf(59);
            conDcp = dcp.substring(0, index).trim();
            dcp = dcp.substring(index + 1).trim();
            index = dcp.indexOf(59);
            protDcp = dcp.substring(0, index).trim();
            dcp = dcp.substring(index + 1).trim();
            rootOid = dcp.trim().trim();
        }
        Object rootObject = null;
        XBridgeFactory xBridgeFactory = null;
        XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
        try {
            xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)xLocalServiceManager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", xLocalContext));
        }
        catch (com.sun.star.uno.Exception e) {
            throw new com.sun.star.uno.RuntimeException((Throwable)e);
        }
        LocalOfficeConnection localOfficeConnection = this;
        synchronized (localOfficeConnection) {
            if (this.mBridge == null) {
                Object connector = null;
                try {
                    connector = xLocalServiceManager.createInstanceWithContext("com.sun.star.connection.Connector", xLocalContext);
                }
                catch (com.sun.star.uno.Exception e) {
                    throw new com.sun.star.uno.RuntimeException((Throwable)e);
                }
                XConnector connector_xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)connector);
                XConnection xConnection = connector_xConnector.connect(conDcp);
                String sBridgeName = "OOoBean_private_bridge_" + m_nBridgeCounter.getAndIncrement();
                try {
                    this.mBridge = xBridgeFactory.createBridge(sBridgeName, protDcp, xConnection, null);
                }
                catch (BridgeExistsException e) {
                    throw new com.sun.star.uno.RuntimeException((Throwable)e);
                }
            }
            rootObject = this.mBridge.getInstance(rootOid);
            return rootObject;
        }
    }

    private void parseUnoUrlWithOfficePath(String url, String prefix) throws MalformedURLException {
        int idx = url.indexOf(";urp;StarOffice.ServiceManager");
        if (idx < 0) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        String params = url.substring(prefix.length(), idx + 1);
        String name = null;
        String path = null;
        String pipe = null;
        int state = 0;
        StringBuffer buffer = new StringBuffer();
        block35: for (idx = 0; idx < params.length(); ++idx) {
            char ch = params.charAt(idx);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case ',': {
                            buffer.delete(0, buffer.length());
                            state = 1;
                            continue block35;
                        }
                        case ';': {
                            state = 7;
                            continue block35;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 1;
                    continue block35;
                }
                case 1: {
                    switch (ch) {
                        case ' ': 
                        case '=': {
                            name = buffer.toString();
                            state = ch == ' ' ? 2 : 3;
                            continue block35;
                        }
                        case ',': 
                        case ';': {
                            state = -6;
                            continue block35;
                        }
                    }
                    buffer.append(ch);
                    continue block35;
                }
                case 2: {
                    switch (ch) {
                        case '=': {
                            state = 3;
                            continue block35;
                        }
                        case ' ': {
                            continue block35;
                        }
                    }
                    state = -1;
                    continue block35;
                }
                case 3: {
                    switch (ch) {
                        case ' ': {
                            continue block35;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 4;
                    continue block35;
                }
                case 4: {
                    switch (ch) {
                        case ' ': 
                        case ',': 
                        case ';': {
                            --idx;
                            state = 5;
                            if (name.equals("path")) {
                                if (path == null) {
                                    path = buffer.toString();
                                } else {
                                    state = -3;
                                }
                            } else if (name.equals("pipe")) {
                                if (pipe == null) {
                                    pipe = buffer.toString();
                                } else {
                                    state = -4;
                                }
                            } else {
                                state = -2;
                            }
                            buffer.delete(0, buffer.length());
                            continue block35;
                        }
                    }
                    buffer.append(ch);
                    continue block35;
                }
                case 5: {
                    switch (ch) {
                        case ' ': {
                            continue block35;
                        }
                        case ',': {
                            state = 6;
                            continue block35;
                        }
                        case ';': {
                            state = 7;
                            continue block35;
                        }
                    }
                    state = -5;
                    continue block35;
                }
                case 6: {
                    switch (ch) {
                        case ' ': {
                            continue block35;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 1;
                    continue block35;
                }
                default: {
                    throw new MalformedURLException("Invalid UNO connection URL.");
                }
            }
        }
        if (state != 7) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        if (pipe != null) {
            this.mPipe = pipe;
        }
    }

    private static String getPipeName() throws UnsupportedEncodingException {
        String aPipeName = System.getProperty("user.name") + OFFICE_ID_SUFFIX;
        aPipeName = aPipeName.replace("_", "%B7");
        return URLEncoder.encode(aPipeName, "UTF-8").replace("+", "%20").replace("%", "_");
    }

    static {
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"msvcr70");
            }
            catch (Throwable e) {
                System.err.println("cannot find msvcr70");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"msvcr71");
            }
            catch (Throwable e) {
                System.err.println("cannot find msvcr71");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"uwinapi");
            }
            catch (Throwable e) {
                System.err.println("cannot find uwinapi:");
                e.printStackTrace();
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"jawt");
            }
            catch (Throwable e) {
                System.err.println("cannot find jawt:");
                e.printStackTrace();
            }
        }
        NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)OFFICE_LIB_NAME);
    }

    private static class StreamProcessor
    extends Thread {
        private final InputStream m_in;
        private final PrintStream m_print;

        public StreamProcessor(InputStream in, PrintStream out) {
            super("StreamProcessor");
            this.m_in = in;
            this.m_print = out;
            this.start();
        }

        public void run() {
            try {
                String s;
                BufferedReader r = new BufferedReader(new InputStreamReader(this.m_in, "UTF-8"));
                while ((s = r.readLine()) != null) {
                    this.m_print.println(s);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace(System.err);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private class OfficeService
    implements NativeService {
        private OfficeService() {
        }

        public String getIdentifier() {
            String identifier = null;
            try {
                identifier = LocalOfficeConnection.this.mPipe == null ? LocalOfficeConnection.getPipeName() : LocalOfficeConnection.this.mPipe;
            }
            catch (UnsupportedEncodingException e) {
                throw new com.sun.star.uno.RuntimeException((Throwable)e);
            }
            return identifier;
        }

        public void startupService() throws IOException {
            int nSizeCmdArray = 4;
            String sOption = null;
            try {
                sOption = System.getProperty("com.sun.star.officebean.Options");
                if (sOption != null) {
                    ++nSizeCmdArray;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            Object[] cmdArray = new String[nSizeCmdArray];
            String unoPath = System.getenv("UNO_PATH");
            if (unoPath == null) {
                throw new IOException("UNO_PATH environment variable is not set (required system path to the office program directory)");
            }
            cmdArray[0] = new File(unoPath, LocalOfficeConnection.OFFICE_APP_NAME).getPath();
            cmdArray[1] = "--nologo";
            cmdArray[2] = "--nodefault";
            if (LocalOfficeConnection.this.mConnType.equals("pipe")) {
                cmdArray[3] = "--accept=pipe,name=" + this.getIdentifier() + ";" + LocalOfficeConnection.this.mProtocol + ";" + LocalOfficeConnection.this.mInitialObject;
            } else if (LocalOfficeConnection.this.mConnType.equals("socket")) {
                cmdArray[3] = "--accept=socket,port=" + LocalOfficeConnection.this.mPort + ";urp";
            } else {
                throw new IOException("not connection specified");
            }
            if (sOption != null) {
                cmdArray[4] = sOption;
            }
            LocalOfficeConnection.this.mProcess = Runtime.getRuntime().exec((String[])cmdArray);
            if (LocalOfficeConnection.this.mProcess == null) {
                throw new com.sun.star.uno.RuntimeException("cannot start soffice: " + Arrays.toString(cmdArray));
            }
            new StreamProcessor(LocalOfficeConnection.this.mProcess.getInputStream(), System.out);
            new StreamProcessor(LocalOfficeConnection.this.mProcess.getErrorStream(), System.err);
        }

        public int getStartupTime() {
            return 60;
        }
    }
}

