/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.DefaultIncludedBuild;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.IncludedBuildFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultIncludedBuildFactory
implements IncludedBuildFactory,
Stoppable {
    private final Instantiator instantiator;
    private final StartParameter startParameter;
    private final GradleLauncherFactory gradleLauncherFactory;
    private final ServiceRegistry sharedServices;
    private final Set<GradleLauncher> launchers = Sets.newHashSet();

    public DefaultIncludedBuildFactory(Instantiator instantiator, StartParameter startParameter, GradleLauncherFactory gradleLauncherFactory, ServiceRegistry sharedServices) {
        this.instantiator = instantiator;
        this.startParameter = startParameter;
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.sharedServices = sharedServices;
    }

    private void validateBuildDirectory(File dir) {
        if (!dir.exists()) {
            throw new InvalidUserDataException(String.format("Included build '%s' does not exist.", dir));
        }
        if (!dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Included build '%s' is not a directory.", dir));
        }
    }

    private void validateIncludedBuild(IncludedBuild includedBuild, SettingsInternal settings) {
        if (!new File(settings.getSettingsDir(), "settings.gradle").exists()) {
            throw new InvalidUserDataException(String.format("Included build '%s' must have a 'settings.gradle' file.", includedBuild.getName()));
        }
        if (!settings.getIncludedBuilds().isEmpty()) {
            throw new InvalidUserDataException(String.format("Included build '%s' cannot have included builds.", includedBuild.getName()));
        }
    }

    public ConfigurableIncludedBuild createBuild(File buildDirectory) {
        this.validateBuildDirectory(buildDirectory);
        ContextualGradleLauncherFactory factory = new ContextualGradleLauncherFactory(buildDirectory, this.gradleLauncherFactory, this.startParameter, this.sharedServices);
        DefaultIncludedBuild includedBuild = (DefaultIncludedBuild)this.instantiator.newInstance(DefaultIncludedBuild.class, new Object[]{buildDirectory, factory});
        SettingsInternal settingsInternal = includedBuild.getLoadedSettings();
        this.validateIncludedBuild((IncludedBuild)includedBuild, settingsInternal);
        return includedBuild;
    }

    public void stop() {
        CompositeStoppable.stoppable(this.launchers).stop();
    }

    private class ContextualGradleLauncherFactory
    implements Factory<GradleLauncher> {
        private final File buildDirectory;
        private final GradleLauncherFactory gradleLauncherFactory;
        private final StartParameter buildStartParam;
        private final ServiceRegistry sharedServices;

        public ContextualGradleLauncherFactory(File buildDirectory, GradleLauncherFactory gradleLauncherFactory, StartParameter buildStartParam, ServiceRegistry sharedServices) {
            this.buildDirectory = buildDirectory;
            this.gradleLauncherFactory = gradleLauncherFactory;
            this.buildStartParam = buildStartParam;
            this.sharedServices = sharedServices;
        }

        public GradleLauncher create() {
            StartParameter participantStartParam = this.createStartParameter(this.buildDirectory);
            GradleLauncher gradleLauncher = this.gradleLauncherFactory.nestedInstance(participantStartParam, this.sharedServices);
            DefaultIncludedBuildFactory.this.launchers.add(gradleLauncher);
            return gradleLauncher;
        }

        private StartParameter createStartParameter(File buildDirectory) {
            StartParameter includedBuildStartParam = this.buildStartParam.newBuild();
            includedBuildStartParam.setProjectDir(buildDirectory);
            includedBuildStartParam.setSearchUpwards(false);
            includedBuildStartParam.setConfigureOnDemand(false);
            return includedBuildStartParam;
        }
    }
}

