/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.collections.DefaultDirectoryWalkerFactory;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.cache.TaskOutputPacker;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;

public class TarTaskOutputPacker
implements TaskOutputPacker {
    private static final Pattern PROPERTY_PATH = Pattern.compile("property-([^/]+)(?:/(.*))?");
    private final DefaultDirectoryWalkerFactory directoryWalkerFactory;
    private final FileSystem fileSystem;

    public TarTaskOutputPacker(FileSystem fileSystem) {
        this.directoryWalkerFactory = new DefaultDirectoryWalkerFactory(JavaVersion.current(), fileSystem);
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(TaskOutputsInternal taskOutputs, OutputStream output) throws IOException {
        TarOutputStream outputStream = new TarOutputStream(output, "utf-8");
        outputStream.setLongFileMode(3);
        outputStream.setBigNumberMode(2);
        outputStream.setAddPaxHeadersForNonAsciiNames(true);
        try {
            this.pack(taskOutputs, outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    private void pack(TaskOutputsInternal taskOutputs, TarOutputStream outputStream) {
        for (TaskOutputFilePropertySpec spec : taskOutputs.getFileProperties()) {
            try {
                this.packProperty((CacheableTaskOutputFilePropertySpec)spec, outputStream);
            }
            catch (Exception ex) {
                throw new GradleException(String.format("Could not pack property '%s'", spec.getPropertyName()), (Throwable)ex);
            }
        }
    }

    private void packProperty(CacheableTaskOutputFilePropertySpec propertySpec, TarOutputStream outputStream) throws IOException {
        String propertyName = propertySpec.getPropertyName();
        File outputFile = propertySpec.getOutputFile();
        switch (propertySpec.getOutputType()) {
            case DIRECTORY: {
                this.storeDirectoryProperty(propertyName, outputFile, outputStream);
                break;
            }
            case FILE: {
                this.storeFileProperty(propertyName, outputFile, outputStream);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void storeDirectoryProperty(String propertyName, File directory, final TarOutputStream outputStream) throws IOException {
        final String propertyRoot = "property-" + propertyName + "/";
        outputStream.putNextEntry(new TarEntry(propertyRoot));
        FileVisitor visitor = new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                TarTaskOutputPacker.this.storeDirectoryEntry(dirDetails, propertyRoot, outputStream);
            }

            public void visitFile(FileVisitDetails fileDetails) {
                String path = propertyRoot + fileDetails.getRelativePath().getPathString();
                TarTaskOutputPacker.this.storeFileEntry(fileDetails.getFile(), path, fileDetails.getLastModified(), fileDetails.getSize(), fileDetails.getMode(), outputStream);
            }
        };
        this.directoryWalkerFactory.create().walkDir(directory, RelativePath.EMPTY_ROOT, visitor, (Spec<? super FileTreeElement>)Specs.satisfyAll(), new AtomicBoolean(), false);
    }

    private void storeFileProperty(String propertyName, File file, TarOutputStream outputStream) {
        String path = "property-" + propertyName;
        this.storeFileEntry(file, path, file.lastModified(), file.length(), this.fileSystem.getUnixMode(file), outputStream);
    }

    private void storeDirectoryEntry(FileVisitDetails dirDetails, String propertyRoot, TarOutputStream outputStream) {
        String path = dirDetails.getRelativePath().getPathString();
        try {
            TarEntry entry = new TarEntry(propertyRoot + path + "/");
            entry.setModTime(dirDetails.getLastModified());
            entry.setMode(0x4000 | dirDetails.getMode());
            outputStream.putNextEntry(entry);
            outputStream.closeEntry();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void storeFileEntry(File file, String path, long lastModified, long size, int mode, TarOutputStream outputStream) {
        try {
            TarEntry entry = new TarEntry(path);
            entry.setModTime(lastModified);
            entry.setSize(size);
            entry.setMode(0x8000 | mode);
            outputStream.putNextEntry(entry);
            Files.copy((File)file, (OutputStream)outputStream);
            outputStream.closeEntry();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(TaskOutputsInternal taskOutputs, InputStream input) throws IOException {
        TarInputStream tarInput = new TarInputStream(input);
        try {
            this.unpack(taskOutputs, tarInput);
        }
        finally {
            tarInput.close();
        }
    }

    private void unpack(TaskOutputsInternal taskOutputs, TarInputStream tarInput) throws IOException {
        TarEntry entry;
        ImmutableMap propertySpecs = Maps.uniqueIndex(taskOutputs.getFileProperties(), (Function)new Function<TaskFilePropertySpec, String>(){

            public String apply(TaskFilePropertySpec propertySpec) {
                return propertySpec.getPropertyName();
            }
        });
        HashSet seenProperties = Sets.newHashSet();
        while ((entry = tarInput.getNextEntry()) != null) {
            String path;
            String name = entry.getName();
            Matcher matcher = PROPERTY_PATH.matcher(name);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached result format error, invalid contents: " + name);
            }
            String propertyName = matcher.group(1);
            CacheableTaskOutputFilePropertySpec propertySpec = (CacheableTaskOutputFilePropertySpec)propertySpecs.get(propertyName);
            if (propertySpec == null) {
                throw new IllegalStateException(String.format("No output property '%s' registered", propertyName));
            }
            File specRoot = propertySpec.getOutputFile();
            if (seenProperties.add(propertySpec)) {
                FileUtils.forceMkdir((File)specRoot.getParentFile());
            }
            File outputFile = Strings.isNullOrEmpty((String)(path = matcher.group(2))) ? specRoot : new File(specRoot, path);
            if (entry.isDirectory()) {
                if (propertySpec.getOutputType() != CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY) {
                    throw new IllegalStateException("Property should be an output directory property: " + propertyName);
                }
                FileUtils.forceMkdir((File)outputFile);
            } else {
                Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom((InputStream)tarInput);
            }
            this.fileSystem.chmod(outputFile, entry.getMode() & 0x1FF);
            if (outputFile.setLastModified(entry.getModTime().getTime())) continue;
            throw new IOException(String.format("Could not set modification time for '%s'", outputFile));
        }
    }
}

