/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.util.Collections;
import org.gradle.StartParameter;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.progress.BuildOperationDetails;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSourceBuilder.class);
    private final GradleLauncherFactory gradleLauncherFactory;
    private final ClassLoaderScope classLoaderScope;
    private final CacheRepository cacheRepository;
    private final BuildOperationExecutor buildOperationExecutor;
    private final CachedClasspathTransformer cachedClasspathTransformer;

    public BuildSourceBuilder(GradleLauncherFactory gradleLauncherFactory, ClassLoaderScope classLoaderScope, CacheRepository cacheRepository, BuildOperationExecutor buildOperationExecutor, CachedClasspathTransformer cachedClasspathTransformer) {
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.classLoaderScope = classLoaderScope;
        this.cacheRepository = cacheRepository;
        this.buildOperationExecutor = buildOperationExecutor;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
    }

    public ClassLoaderScope buildAndCreateClassLoader(StartParameter startParameter) {
        ClassPath classpath = this.createBuildSourceClasspath(startParameter);
        ClassLoaderScope childScope = this.classLoaderScope.createChild(startParameter.getCurrentDir().getAbsolutePath());
        childScope.export(this.cachedClasspathTransformer.transform(classpath));
        childScope.lock();
        return childScope;
    }

    ClassPath createBuildSourceClasspath(final StartParameter startParameter) {
        assert (startParameter.getCurrentDir() != null && startParameter.getBuildFile() == null);
        LOGGER.debug("Starting to build the build sources.");
        if (!startParameter.getCurrentDir().isDirectory()) {
            LOGGER.debug("Gradle source dir does not exist. We leave.");
            return new DefaultClassPath(new File[0]);
        }
        return this.buildOperationExecutor.run(BuildOperationDetails.displayName("Build buildSrc").progressDisplayName("buildSrc").build(), new Factory<ClassPath>(){

            public ClassPath create() {
                return BuildSourceBuilder.this.buildBuildSrc(startParameter);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath buildBuildSrc(StartParameter startParameter) {
        PersistentCache buildSrcCache = this.createCache(startParameter);
        try {
            ClassPath classPath;
            GradleLauncher gradleLauncher = this.buildGradleLauncher(startParameter);
            try {
                classPath = (ClassPath)buildSrcCache.useCache("rebuild buildSrc", new BuildSrcUpdateFactory(buildSrcCache, gradleLauncher, new BuildSrcBuildListenerFactory()));
            }
            catch (Throwable throwable) {
                gradleLauncher.stop();
                throw throwable;
            }
            gradleLauncher.stop();
            return classPath;
        }
        finally {
            buildSrcCache.close();
        }
    }

    PersistentCache createCache(StartParameter startParameter) {
        return this.cacheRepository.cache(new File(startParameter.getCurrentDir(), ".gradle/noVersion/buildSrc")).withCrossVersionCache(CacheBuilder.LockTarget.CachePropertiesFile).withDisplayName("buildSrc state cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None).useCrossVersionImplementation()).withProperties(Collections.singletonMap("gradle.version", GradleVersion.current().getVersion())).open();
    }

    private GradleLauncher buildGradleLauncher(StartParameter startParameter) {
        StartParameter startParameterArg = startParameter.newInstance();
        startParameterArg.setProjectProperties(startParameter.getProjectProperties());
        startParameterArg.setSearchUpwards(false);
        startParameterArg.setProfile(startParameter.isProfile());
        return this.gradleLauncherFactory.nestedInstance(startParameterArg);
    }
}

