/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.internal.typeconversion.CharSequenceNotationConverter;
import org.gradle.internal.typeconversion.CharSequenceNotationParser;
import org.gradle.internal.typeconversion.CompositeNotationConverter;
import org.gradle.internal.typeconversion.ErrorHandlingNotationParser;
import org.gradle.internal.typeconversion.FlatteningNotationParser;
import org.gradle.internal.typeconversion.JustReturningConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TypeFilteringNotationConverter;
import org.gradle.internal.typeconversion.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotationParserBuilder<T> {
    private TypeInfo<T> resultingType;
    private String invalidNotationMessage;
    private String typeDisplayName;
    private boolean implicitConverters = true;
    private boolean allowNullInput;
    private final Collection<NotationConverter<Object, ? extends T>> notationParsers = new LinkedList<NotationConverter<Object, ? extends T>>();

    public static <T> NotationParserBuilder<T> toType(Class<T> resultingType) {
        return new NotationParserBuilder(new TypeInfo(resultingType));
    }

    public static <T> NotationParserBuilder<T> toType(TypeInfo<T> resultingType) {
        return new NotationParserBuilder<T>(resultingType);
    }

    private NotationParserBuilder(TypeInfo<T> resultingType) {
        this.resultingType = resultingType;
    }

    public NotationParserBuilder<T> typeDisplayName(String name) {
        this.typeDisplayName = name;
        return this;
    }

    public NotationParserBuilder<T> noImplicitConverters() {
        this.implicitConverters = false;
        return this;
    }

    public NotationParserBuilder<T> allowNullInput() {
        this.allowNullInput = true;
        return this;
    }

    public NotationParserBuilder<T> converter(NotationConverter<Object, ? extends T> converter) {
        this.notationParsers.add(converter);
        return this;
    }

    public <S> NotationParserBuilder<T> fromType(Class<S> notationType, NotationConverter<? super S, ? extends T> converter) {
        this.notationParsers.add(new TypeFilteringNotationConverter(notationType, converter));
        return this;
    }

    public NotationParserBuilder<T> fromCharSequence(NotationConverter<? super String, ? extends T> converter) {
        this.notationParsers.add(new CharSequenceNotationConverter(converter));
        return this;
    }

    public NotationParserBuilder<T> fromCharSequence() {
        if (!this.resultingType.getTargetType().equals(String.class)) {
            throw new UnsupportedOperationException("Can only convert from CharSequence when the target type is String.");
        }
        CharSequenceNotationParser notationParser = new CharSequenceNotationParser();
        this.fromCharSequence(notationParser);
        return this;
    }

    public NotationParserBuilder<T> invalidNotationMessage(String invalidNotationMessage) {
        this.invalidNotationMessage = invalidNotationMessage;
        return this;
    }

    public NotationParser<Object, Set<T>> toFlatteningComposite() {
        return this.wrapInErrorHandling(new FlatteningNotationParser<T>(this.create()));
    }

    public NotationParser<Object, T> toComposite() {
        return this.wrapInErrorHandling(this.create());
    }

    private <S> NotationParser<Object, S> wrapInErrorHandling(NotationParser<Object, S> parser) {
        if (this.typeDisplayName == null) {
            this.typeDisplayName = this.resultingType.getTargetType().equals(String.class) ? "a String" : "an object of type ".concat(this.resultingType.getTargetType().getSimpleName());
        }
        return new ErrorHandlingNotationParser<Object, S>(this.typeDisplayName, this.invalidNotationMessage, this.allowNullInput, parser);
    }

    private NotationParser<Object, T> create() {
        LinkedList composites = new LinkedList();
        if (!this.resultingType.getTargetType().equals(Object.class) && this.implicitConverters) {
            composites.add(new JustReturningConverter(this.resultingType.getTargetType()));
        }
        composites.addAll(this.notationParsers);
        return new NotationConverterToNotationParserAdapter(composites.size() == 1 ? (NotationConverter)composites.get(0) : new CompositeNotationConverter(composites));
    }
}

